/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.fluids;

import appeng.api.storage.data.IAEFluidStack;
import appeng.client.gui.me.common.MEMonitorableScreen;
import appeng.client.gui.me.common.Repo;
import appeng.client.gui.me.fluids.FluidRepo;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.IScrollSource;
import appeng.container.me.common.GridInventoryEntry;
import appeng.container.me.fluids.FluidTerminalContainer;
import appeng.core.AELog;
import appeng.fluids.client.gui.FluidBlitter;
import appeng.helpers.InventoryAction;
import appeng.util.Platform;
import appeng.util.prioritylist.IPartitionList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class FluidTerminalScreen
extends MEMonitorableScreen<IAEFluidStack, FluidTerminalContainer> {
    public FluidTerminalScreen(FluidTerminalContainer container, PlayerInventory playerInventory, ITextComponent title, ScreenStyle style) {
        super(container, playerInventory, title, style);
    }

    @Override
    protected Repo<IAEFluidStack> createRepo(IScrollSource scrollSource) {
        return new FluidRepo(scrollSource, this);
    }

    @Override
    protected IPartitionList<IAEFluidStack> createPartitionList(List<ItemStack> viewCells) {
        return null;
    }

    @Override
    protected void renderGridInventoryEntry(MatrixStack matrices, int x, int y, GridInventoryEntry<IAEFluidStack> entry) {
        IAEFluidStack fs = entry.getStack();
        FluidBlitter.create(fs.getFluidStack()).dest(x, y, 16, 16).blit(matrices, this.func_230927_p_());
    }

    @Override
    protected void renderGridInventoryEntryTooltip(MatrixStack matrices, GridInventoryEntry<IAEFluidStack> entry, int x, int y) {
        IAEFluidStack fluidStack = entry.getStack();
        String formattedAmount = NumberFormat.getNumberInstance(Locale.US).format((double)entry.getStoredAmount() / 1000.0) + " B";
        String modName = Platform.getModName(Platform.getModId(fluidStack));
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(fluidStack.getFluidStack().getDisplayName());
        list.add(new StringTextComponent(formattedAmount));
        list.add(new StringTextComponent(modName));
        this.renderWrappedToolTip(matrices, list, x, y, this.field_230712_o_);
    }

    @Override
    protected void handleGridInventoryEntryMouseClick(@Nullable GridInventoryEntry<IAEFluidStack> entry, int mouseButton, ClickType clickType) {
        if (clickType == ClickType.PICKUP) {
            if (mouseButton == 0 && entry != null) {
                AELog.debug("mouse0 GUI STACK SIZE %s", entry.getStoredAmount());
                ((FluidTerminalContainer)this.field_147002_h).handleInteraction(entry.getSerial(), InventoryAction.FILL_ITEM);
            } else {
                if (entry != null) {
                    AELog.debug("mouse1 GUI STACK SIZE %s", entry.getStoredAmount());
                }
                ((FluidTerminalContainer)this.field_147002_h).handleInteraction(-1L, InventoryAction.EMPTY_ITEM);
            }
        }
    }
}

