/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.crafting;

import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.me.crafting.CraftingStatusTableRenderer;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.Scrollbar;
import appeng.container.me.crafting.CraftingCPUContainer;
import appeng.container.me.crafting.CraftingStatus;
import appeng.container.me.crafting.CraftingStatusEntry;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class CraftingCPUScreen<T extends CraftingCPUContainer>
extends AEBaseScreen<T> {
    private final CraftingStatusTableRenderer table = new CraftingStatusTableRenderer(this, 9, 19);
    private final Button cancel;
    private final Scrollbar scrollbar = this.widgets.addScrollBar("scrollbar");
    private CraftingStatus status;

    public CraftingCPUScreen(T container, PlayerInventory playerInventory, ITextComponent title, ScreenStyle style) {
        super(container, playerInventory, title, style);
        this.cancel = this.widgets.addButton("cancel", GuiText.Cancel.text(), this::cancel);
    }

    private void cancel() {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("TileCrafting.Cancel", "Cancel"));
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        ITextComponent title = this.getGuiDisplayName(GuiText.CraftingStatus.text());
        if (this.status != null) {
            long elapsedTime = this.status.getElapsedTime();
            double remainingItems = this.status.getRemainingItemCount();
            double startItems = this.status.getStartItemCount();
            long eta = (long)((double)elapsedTime / Math.max(1.0, startItems - remainingItems) * remainingItems);
            if (eta > 0L && !this.getVisualEntries().isEmpty()) {
                long etaInMilliseconds = TimeUnit.MILLISECONDS.convert(eta, TimeUnit.NANOSECONDS);
                String etaTimeText = DurationFormatUtils.formatDuration((long)etaInMilliseconds, (String)GuiText.ETAFormat.getLocal());
                title = title.func_230532_e_().func_240702_b_(" - " + etaTimeText);
            }
        }
        this.setTextContent("dialog_title", title);
        int size = this.status != null ? this.status.getEntries().size() : 0;
        this.scrollbar.setRange(0, CraftingStatusTableRenderer.getScrollableRows(size), 1);
    }

    private List<CraftingStatusEntry> getVisualEntries() {
        return this.status != null ? this.status.getEntries() : Collections.emptyList();
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float btn) {
        this.cancel.field_230693_o_ = !this.getVisualEntries().isEmpty();
        super.func_230430_a_(matrixStack, mouseX, mouseY, btn);
    }

    @Override
    public void drawFG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY) {
        super.drawFG(matrixStack, offsetX, offsetY, mouseX, mouseY);
        if (this.status != null) {
            this.table.render(matrixStack, mouseX, mouseY, this.status.getEntries(), this.scrollbar.getCurrentScroll());
        }
    }

    public void postUpdate(CraftingStatus status) {
        if (this.status == null || status.isFullStatus()) {
            this.status = status;
        } else {
            LinkedHashMap<Long, CraftingStatusEntry> entries = new LinkedHashMap<Long, CraftingStatusEntry>(this.status.getEntries().size());
            for (CraftingStatusEntry entry : this.status.getEntries()) {
                entries.put(entry.getSerial(), entry);
            }
            for (CraftingStatusEntry entry : status.getEntries()) {
                if (entry.isDeleted()) {
                    entries.remove(entry.getSerial());
                    continue;
                }
                CraftingStatusEntry existingEntry = (CraftingStatusEntry)entries.get(entry.getSerial());
                if (existingEntry != null) {
                    entries.put(entry.getSerial(), new CraftingStatusEntry(existingEntry.getSerial(), existingEntry.getItem(), entry.getStoredAmount(), entry.getActiveAmount(), entry.getPendingAmount()));
                    continue;
                }
                entries.put(entry.getSerial(), entry);
            }
            ArrayList<CraftingStatusEntry> sortedEntries = new ArrayList<CraftingStatusEntry>(entries.values());
            this.status = new CraftingStatus(true, status.getElapsedTime(), status.getRemainingItemCount(), status.getStartItemCount(), sortedEntries);
        }
    }
}

