/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.crafting;

import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.style.PaletteColor;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;

public abstract class AbstractTableRenderer<T> {
    private static final int CELL_WIDTH = 67;
    private static final int CELL_HEIGHT = 22;
    private static final int ROWS = 5;
    private static final int COLS = 3;
    private static final int CELL_BORDER = 1;
    private static final int LINE_SPACING = 1;
    private static final float TEXT_SCALE = 0.5f;
    private static final float INV_TEXT_SCALE = 2.0f;
    protected final AEBaseScreen<?> screen;
    private final FontRenderer fontRenderer;
    private final float lineHeight;
    private final int x;
    private final int y;

    public AbstractTableRenderer(AEBaseScreen<?> screen, int x, int y) {
        this.screen = screen;
        this.x = x;
        this.y = y;
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.fontRenderer.getClass();
        this.lineHeight = 9.0f * 0.5f;
    }

    public final void render(MatrixStack matrixStack, int mouseX, int mouseY, List<T> entries, int scrollOffset) {
        mouseX -= this.screen.getGuiLeft();
        mouseY -= this.screen.getGuiTop();
        int textColor = this.screen.getStyle().getColor(PaletteColor.DEFAULT_TEXT_COLOR).toARGB();
        List<ITextComponent> tooltipLines = null;
        for (int row = 0; row < 5; ++row) {
            int i;
            for (int col = 0; col < 3 && (i = (row + scrollOffset) * 3 + col) < entries.size(); ++col) {
                T entry = entries.get(i);
                int cellX = this.x + col * 68;
                int cellY = this.y + row * 23;
                int background = this.getEntryBackgroundColor(entry);
                if (background != 0) {
                    AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)cellX, (int)cellY, (int)(cellX + 67), (int)(cellY + 22), (int)background);
                }
                List<ITextComponent> lines = this.getEntryDescription(entry);
                float textHeight = (float)lines.size() * this.lineHeight;
                if (lines.size() > 1) {
                    textHeight += (float)((lines.size() - 1) * 1);
                }
                float textY = Math.round((float)cellY + (22.0f - textHeight) / 2.0f);
                int itemX = cellX + 67 - 19;
                matrixStack.func_227860_a_();
                matrixStack.func_227862_a_(0.5f, 0.5f, 1.0f);
                for (ITextComponent line : lines) {
                    int w = this.fontRenderer.func_238414_a_((ITextProperties)line);
                    this.fontRenderer.func_243248_b(matrixStack, line, (float)((int)(((float)(itemX - 2) - (float)w * 0.5f) * 2.0f)), textY * 2.0f, textColor);
                    textY += this.lineHeight + 1.0f;
                }
                matrixStack.func_227865_b_();
                ItemStack is = this.getEntryItem(entry);
                int itemY = cellY + 3;
                this.screen.drawItem(itemX, itemY, is);
                int overlay = this.getEntryOverlayColor(entry);
                if (overlay != 0) {
                    AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)cellX, (int)cellY, (int)(cellX + 67), (int)(cellY + 22), (int)overlay);
                }
                if (mouseX < cellX || mouseX > cellX + 67 || mouseY < cellY || mouseY > cellY + 22) continue;
                tooltipLines = this.getEntryTooltip(entry);
            }
        }
        if (tooltipLines != null) {
            this.screen.drawTooltip(matrixStack, mouseX, mouseY, tooltipLines);
        }
    }

    public static int getScrollableRows(int size) {
        return (size + 3 - 1) / 3 - 5;
    }

    protected abstract List<ITextComponent> getEntryDescription(T var1);

    protected abstract ItemStack getEntryItem(T var1);

    protected abstract List<ITextComponent> getEntryTooltip(T var1);

    protected int getEntryBackgroundColor(T entry) {
        return 0;
    }

    protected int getEntryOverlayColor(T entry) {
        return 0;
    }
}

