/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.Upgrades;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.parts.IPart;
import appeng.api.parts.PartItemStack;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ToolboxPanel;
import appeng.client.gui.widgets.UpgradesPanel;
import appeng.container.AEBaseContainer;
import appeng.container.SlotSemantic;
import appeng.container.implementations.UpgradeableContainer;
import appeng.core.localization.GuiText;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class UpgradeableScreen<T extends UpgradeableContainer>
extends AEBaseScreen<T> {
    public UpgradeableScreen(T container, PlayerInventory playerInventory, ITextComponent title, ScreenStyle style) {
        super(container, playerInventory, title, style);
        this.widgets.add("upgrades", new UpgradesPanel(((AEBaseContainer)((Object)container)).getSlots(SlotSemantic.UPGRADE), this::getCompatibleUpgrades));
        if (((UpgradeableContainer)container).hasToolbox()) {
            this.widgets.add("toolbox", new ToolboxPanel(style, ((UpgradeableContainer)container).getToolboxName()));
        }
    }

    protected List<ITextComponent> getCompatibleUpgrades() {
        Item item;
        IUpgradeableHost host = ((UpgradeableContainer)this.field_147002_h).getUpgradeable();
        if (host instanceof IPart) {
            item = ((IPart)((Object)host)).getItemStack(PartItemStack.NETWORK).func_77973_b();
        } else if (host instanceof TileEntity) {
            TileEntity te = (TileEntity)host;
            item = te.func_195044_w().func_177230_c().func_199767_j();
        } else {
            return Collections.emptyList();
        }
        return this.getCompatibleUpgrades(item);
    }

    protected List<ITextComponent> getCompatibleUpgrades(Item machineItem) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add(GuiText.CompatibleUpgrades.text());
        block0: for (Upgrades upgrade : Upgrades.values()) {
            for (Upgrades.Supported supported : upgrade.getSupported()) {
                if (!supported.isSupported(machineItem)) continue;
                list.add((ITextComponent)GuiText.CompatibleUpgrade.text(upgrade.getDisplayName(), supported.getMaxCount()).func_240699_a_(TextFormatting.GRAY));
                continue block0;
            }
        }
        return list;
    }
}

