/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.NumberEntryType;
import appeng.client.gui.implementations.AESubScreen;
import appeng.client.gui.implementations.NumberEntryWidget;
import appeng.client.gui.style.ScreenStyle;
import appeng.container.implementations.PriorityContainer;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.OptionalInt;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class PriorityScreen
extends AEBaseScreen<PriorityContainer> {
    private final AESubScreen subGui;
    private final NumberEntryWidget priority;

    public PriorityScreen(PriorityContainer container, PlayerInventory playerInventory, ITextComponent title, ScreenStyle style) {
        super(container, playerInventory, title, style);
        this.subGui = new AESubScreen(container.getPriorityHost());
        this.subGui.addBackButton("back", this.widgets);
        this.priority = new NumberEntryWidget(NumberEntryType.PRIORITY);
        this.priority.setTextFieldBounds(62, 57, 50);
        this.priority.setMinValue(Integer.MIN_VALUE);
        this.priority.setValue(((PriorityContainer)this.field_147002_h).getPriorityValue());
        this.priority.setOnChange(this::savePriority);
        this.priority.setOnConfirm(() -> {
            this.savePriority();
            this.subGui.goBack();
        });
        this.widgets.add("priority", this.priority);
    }

    private void savePriority() {
        OptionalInt priority = this.priority.getIntValue();
        if (priority.isPresent()) {
            ((PriorityContainer)this.field_147002_h).setPriority(priority.getAsInt());
        }
    }

    @Override
    public void drawBG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        super.drawBG(matrixStack, offsetX, offsetY, mouseX, mouseY, partialTicks);
        this.priority.render(matrixStack, mouseX, mouseY, partialTicks);
    }
}

