/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui;

import appeng.client.Point;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.ICompositeWidget;
import appeng.client.gui.Icon;
import appeng.client.gui.Tooltip;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.style.WidgetStyle;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.gui.widgets.TabButton;
import appeng.container.implementations.PriorityContainer;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.SwitchGuisPacket;
import com.google.common.base.Preconditions;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.util.text.ITextComponent;

public class WidgetContainer {
    private final ScreenStyle style;
    private final Map<String, Widget> widgets = new HashMap<String, Widget>();
    private final Map<String, ICompositeWidget> compositeWidgets = new HashMap<String, ICompositeWidget>();

    public WidgetContainer(ScreenStyle style) {
        this.style = style;
    }

    public void add(String id, Widget widget) {
        Preconditions.checkState((!this.compositeWidgets.containsKey(id) ? 1 : 0) != 0, (String)"%s already used for composite widget", (Object)id);
        WidgetStyle widgetStyle = this.style.getWidget(id);
        if (widgetStyle.getWidth() != 0) {
            widget.func_230991_b_(widgetStyle.getWidth());
        }
        if (widgetStyle.getHeight() != 0) {
            widget.setHeight(widgetStyle.getHeight());
        }
        if (widget instanceof TabButton) {
            ((TabButton)widget).setHideEdge(widgetStyle.isHideEdge());
        }
        if (this.widgets.put(id, widget) != null) {
            throw new IllegalStateException("Duplicate id: " + id);
        }
    }

    public void add(String id, ICompositeWidget widget) {
        Preconditions.checkState((!this.widgets.containsKey(id) ? 1 : 0) != 0, (String)"%s already used for widget", (Object)id);
        WidgetStyle widgetStyle = this.style.getWidget(id);
        widget.setSize(widgetStyle.getWidth(), widgetStyle.getHeight());
        if (this.compositeWidgets.put(id, widget) != null) {
            throw new IllegalStateException("Duplicate id: " + id);
        }
    }

    public Button addButton(String id, ITextComponent text, Button.IPressable action, Button.ITooltip tooltip) {
        Button button = new Button(0, 0, 0, 0, text, action, tooltip);
        this.add(id, (Widget)button);
        return button;
    }

    public Button addButton(String id, ITextComponent text, Button.IPressable action) {
        return this.addButton(id, text, action, Button.field_238486_s_);
    }

    public Button addButton(String id, ITextComponent text, Runnable action, Button.ITooltip tooltip) {
        return this.addButton(id, text, btn -> action.run(), tooltip);
    }

    public Button addButton(String id, ITextComponent text, Runnable action) {
        return this.addButton(id, text, action, Button.field_238486_s_);
    }

    public Scrollbar addScrollBar(String id) {
        Scrollbar scrollbar = new Scrollbar();
        this.add(id, scrollbar);
        return scrollbar;
    }

    void populateScreen(Consumer<Widget> addWidget, Rectangle2d bounds, AEBaseScreen<?> screen) {
        for (Map.Entry<String, Widget> entry : this.widgets.entrySet()) {
            Widget widget = entry.getValue();
            WidgetStyle widgetStyle = this.style.getWidget(entry.getKey());
            Point pos = widgetStyle.resolve(bounds);
            widget.field_230690_l_ = pos.getX();
            widget.field_230691_m_ = pos.getY();
            addWidget.accept(widget);
        }
        Rectangle2d relativeBounds = new Rectangle2d(0, 0, bounds.func_199316_c(), bounds.func_199317_d());
        for (Map.Entry<String, ICompositeWidget> entry : this.compositeWidgets.entrySet()) {
            ICompositeWidget widget = entry.getValue();
            WidgetStyle widgetStyle = this.style.getWidget(entry.getKey());
            widget.setPosition(widgetStyle.resolve(relativeBounds));
            widget.populateScreen(addWidget, bounds, screen);
        }
    }

    public void tick() {
        for (ICompositeWidget widget : this.compositeWidgets.values()) {
            widget.tick();
        }
    }

    public void updateBeforeRender() {
        for (ICompositeWidget widget : this.compositeWidgets.values()) {
            widget.updateBeforeRender();
        }
    }

    public void drawBackgroundLayer(MatrixStack matrices, int zIndex, Rectangle2d bounds, Point mouse) {
        for (ICompositeWidget widget : this.compositeWidgets.values()) {
            widget.drawBackgroundLayer(matrices, zIndex, bounds, mouse);
        }
    }

    public void drawForegroundLayer(MatrixStack matrices, int zIndex, Rectangle2d bounds, Point mouse) {
        for (ICompositeWidget widget : this.compositeWidgets.values()) {
            widget.drawForegroundLayer(matrices, zIndex, bounds, mouse);
        }
    }

    public boolean onMouseDown(Point mousePos, int btn) {
        for (ICompositeWidget widget : this.compositeWidgets.values()) {
            if (!widget.wantsAllMouseDownEvents() && !mousePos.isIn(widget.getBounds()) || !widget.onMouseDown(mousePos, btn)) continue;
            return true;
        }
        return false;
    }

    public boolean onMouseUp(Point mousePos, int btn) {
        for (ICompositeWidget widget : this.compositeWidgets.values()) {
            if (!widget.wantsAllMouseUpEvents() && !mousePos.isIn(widget.getBounds()) || !widget.onMouseUp(mousePos, btn)) continue;
            return true;
        }
        return false;
    }

    public boolean onMouseDrag(Point mousePos, int btn) {
        for (ICompositeWidget widget : this.compositeWidgets.values()) {
            if (!widget.onMouseDrag(mousePos, btn)) continue;
            return true;
        }
        return false;
    }

    boolean onMouseWheel(Point mousePos, double wheelDelta) {
        for (ICompositeWidget widget : this.compositeWidgets.values()) {
            if (!widget.wantsAllMouseWheelEvents() && !mousePos.isIn(widget.getBounds()) || !widget.onMouseWheel(mousePos, wheelDelta)) continue;
            return true;
        }
        return false;
    }

    public void addExclusionZones(List<Rectangle2d> exclusionZones, Rectangle2d bounds) {
        for (ICompositeWidget widget : this.compositeWidgets.values()) {
            widget.addExclusionZones(exclusionZones, bounds);
        }
    }

    public void addOpenPriorityButton() {
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        this.add("openPriority", (Widget)new TabButton(Icon.WRENCH, GuiText.Priority.text(), itemRenderer, btn -> this.openPriorityGui()));
    }

    private void openPriorityGui() {
        NetworkHandler.instance().sendToServer(new SwitchGuisPacket(PriorityContainer.TYPE));
    }

    @Nullable
    public Tooltip getTooltip(int mouseX, int mouseY) {
        for (ICompositeWidget c : this.compositeWidgets.values()) {
            Tooltip tooltip;
            Rectangle2d bounds = c.getBounds();
            if (mouseX < bounds.func_199318_a() || mouseX >= bounds.func_199318_a() + bounds.func_199316_c() || mouseY < bounds.func_199319_b() || mouseY >= bounds.func_199319_b() + bounds.func_199317_d() || (tooltip = c.getTooltip(mouseX, mouseY)) == null) continue;
            return tooltip;
        }
        return null;
    }
}

