/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.parts;

import appeng.api.networking.IGridNode;
import appeng.api.parts.BusSupport;
import appeng.api.parts.ICustomCableConnection;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartModel;
import appeng.api.parts.PartItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public interface IPart
extends ICustomCableConnection {
    public ItemStack getItemStack(PartItemStack var1);

    @OnlyIn(value=Dist.CLIENT)
    default public void renderDynamic(float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffers, int combinedLightIn, int combinedOverlayIn) {
    }

    public boolean requireDynamicRender();

    public boolean isSolid();

    public boolean canConnectRedstone();

    public void writeToNBT(CompoundNBT var1);

    public void readFromNBT(CompoundNBT var1);

    public int getLightLevel();

    public boolean isLadder(LivingEntity var1);

    public void onNeighborChanged(IBlockReader var1, BlockPos var2, BlockPos var3);

    public int isProvidingStrongPower();

    public int isProvidingWeakPower();

    public void writeToStream(PacketBuffer var1) throws IOException;

    public boolean readFromStream(PacketBuffer var1) throws IOException;

    public IGridNode getGridNode();

    public void onEntityCollision(Entity var1);

    public void removeFromWorld();

    public void addToWorld();

    public IGridNode getExternalFacingNode();

    public void setPartHostInfo(AEPartLocation var1, IPartHost var2, TileEntity var3);

    public boolean onActivate(PlayerEntity var1, Hand var2, Vector3d var3);

    public boolean onShiftActivate(PlayerEntity var1, Hand var2, Vector3d var3);

    default public boolean onClicked(PlayerEntity player, Hand hand, Vector3d pos) {
        return false;
    }

    default public boolean onShiftClicked(PlayerEntity player, Hand hand, Vector3d pos) {
        return false;
    }

    public void getDrops(List<ItemStack> var1, boolean var2);

    @Override
    public float getCableConnectionLength(AECableType var1);

    public void animateTick(World var1, BlockPos var2, Random var3);

    public void onPlacement(PlayerEntity var1, Hand var2, ItemStack var3, AEPartLocation var4);

    public boolean canBePlacedOn(BusSupport var1);

    @Nonnull
    default public IPartModel getStaticModels() {
        return new IPartModel(){};
    }

    @Nonnull
    default public <T> LazyOptional<T> getCapability(Capability<T> capabilityClass) {
        return LazyOptional.empty();
    }

    @Nonnull
    default public IModelData getModelData() {
        return EmptyModelData.INSTANCE;
    }

    public void getBoxes(IPartCollisionHelper var1);

    default public void addEntityCrashInfo(CrashReportCategory section) {
    }
}

