/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.integration.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.recipes.GatherReplacementExclusionEvent;
import com.blamejared.crafttweaker.impl.tag.manager.TagManagerBlock;
import com.blamejared.crafttweaker.impl_native.blocks.ExpandBlock;
import com.blamejared.crafttweaker.impl_native.blocks.ExpandBlockState;
import com.mojang.brigadier.context.CommandContext;
import java.util.stream.Collectors;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.OrechidOutput;
import vazkii.botania.api.recipe.IElvenTradeRecipe;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.LexiconElvenTradeRecipe;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.StateIngredientBlock;
import vazkii.botania.common.crafting.StateIngredientBlockState;
import vazkii.botania.common.crafting.StateIngredientBlocks;
import vazkii.botania.common.crafting.StateIngredientTag;

public class CTIntegration {
    public static void register() {
        MinecraftForge.EVENT_BUS.addListener(e -> e.registerDump("orechidOutputs", "Dumps all Botania Orechid outputs", CTIntegration::dumpOrechid));
        MinecraftForge.EVENT_BUS.addListener(e -> {
            IRecipeType type = e.getTargetedManager().getRecipeType();
            if (type == ModRecipeTypes.ELVEN_TRADE_TYPE) {
                e.getTargetedManager().getRecipes().values().stream().map(r -> (IElvenTradeRecipe)r).filter(r -> r instanceof LexiconElvenTradeRecipe).forEach(arg_0 -> ((GatherReplacementExclusionEvent)e).addExclusion(arg_0));
            }
        });
    }

    private static int dumpOrechid(CommandContext<CommandSource> ctx) {
        CraftTweakerAPI.logDump((String)"Orechid: ", (Object[])new Object[0]);
        for (OrechidOutput output : BotaniaAPI.instance().getOrechidWeights()) {
            CraftTweakerAPI.logDump((String)("- " + CTIntegration.ingredientToCommandString(output.getOutput()) + " : " + output.getWeight()), (Object[])new Object[0]);
        }
        CraftTweakerAPI.logDump((String)"Orechid Ignem: ", (Object[])new Object[0]);
        for (OrechidOutput output : BotaniaAPI.instance().getNetherOrechidWeights()) {
            CraftTweakerAPI.logDump((String)("- " + CTIntegration.ingredientToCommandString(output.getOutput()) + " : " + output.getWeight()), (Object[])new Object[0]);
        }
        String msg = "List of Orechid ores generated! Check the crafttweaker.log file.";
        ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent(msg).func_240699_a_(TextFormatting.GREEN), false);
        CraftTweakerAPI.logInfo((String)msg, (Object[])new Object[0]);
        return 0;
    }

    public static String ingredientToCommandString(StateIngredient ingr) {
        if (ingr instanceof StateIngredientTag) {
            ResourceLocation id = ((StateIngredientTag)ingr).getTagId();
            return TagManagerBlock.INSTANCE.getTag(id).getCommandString();
        }
        if (ingr instanceof StateIngredientBlock) {
            return ExpandBlock.getCommandString((Block)((StateIngredientBlock)ingr).getBlock());
        }
        if (ingr instanceof StateIngredientBlockState) {
            return ExpandBlockState.getCommandString((BlockState)((StateIngredientBlockState)ingr).getState());
        }
        if (ingr instanceof StateIngredientBlocks) {
            return ingr.getDisplayed().stream().map(AbstractBlock.AbstractBlockState::func_177230_c).map(ExpandBlock::getCommandString).collect(Collectors.joining(", ", "[", "]"));
        }
        return ingr.toString();
    }
}

