/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import vazkii.botania.common.block.decor.BlockModMushroom;
import vazkii.botania.common.item.ItemTwigWand;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.material.ItemPetal;

public class TwigWandRecipe
implements ICraftingRecipe {
    public static final IRecipeSerializer<TwigWandRecipe> SERIALIZER = new Serializer();
    private final ShapedRecipe compose;

    public TwigWandRecipe(ShapedRecipe compose) {
        this.compose = compose;
    }

    public ShapedRecipe getCompose() {
        return this.compose;
    }

    public boolean matches(@Nonnull CraftingInventory inv, @Nonnull World worldIn) {
        return this.compose.func_77569_a(inv, worldIn);
    }

    @Nonnull
    public ItemStack getCraftingResult(CraftingInventory inv) {
        int first = -1;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            int colorId;
            ItemStack stack = inv.func_70301_a(i);
            Item item = stack.func_77973_b();
            if (item instanceof ItemPetal) {
                colorId = ((ItemPetal)item).color.func_196059_a();
            } else {
                if (!(item instanceof BlockItem) || !(((BlockItem)item).func_179223_d() instanceof BlockModMushroom)) continue;
                colorId = ((BlockModMushroom)((BlockItem)item).func_179223_d()).color.func_196059_a();
            }
            if (first == -1) {
                first = colorId;
                continue;
            }
            return ItemTwigWand.forColors(first, colorId);
        }
        return ItemTwigWand.forColors(first != -1 ? first : 0, 0);
    }

    public boolean func_194133_a(int width, int height) {
        return this.compose.func_194133_a(width, height);
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)ModItems.twigWand);
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.compose.func_199560_c();
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        return this.compose.func_179532_b((IInventory)inv);
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        return this.compose.func_192400_c();
    }

    @Nonnull
    public String func_193358_e() {
        return this.compose.func_193358_e();
    }

    @Nonnull
    public ItemStack func_222128_h() {
        return this.compose.func_222128_h();
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    private static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<TwigWandRecipe> {
        private Serializer() {
        }

        @Nonnull
        public TwigWandRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            return new TwigWandRecipe((ShapedRecipe)field_222157_a.func_199425_a_(recipeId, json));
        }

        @Nullable
        public TwigWandRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
            return new TwigWandRecipe((ShapedRecipe)field_222157_a.func_199426_a_(recipeId, buffer));
        }

        public void write(@Nonnull PacketBuffer buffer, @Nonnull TwigWandRecipe recipe) {
            field_222157_a.func_199427_a_(buffer, (IRecipe)recipe.compose);
        }
    }
}

