/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.world;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import vazkii.botania.client.core.handler.ClientTickHandler;

public class SkyblockSkyRenderer {
    private static final ResourceLocation textureSkybox = new ResourceLocation("botania:textures/misc/skybox.png");
    private static final ResourceLocation textureRainbow = new ResourceLocation("botania:textures/misc/rainbow.png");
    private static final ResourceLocation[] planetTextures = new ResourceLocation[]{new ResourceLocation("botania:textures/misc/planet0.png"), new ResourceLocation("botania:textures/misc/planet1.png"), new ResourceLocation("botania:textures/misc/planet2.png"), new ResourceLocation("botania:textures/misc/planet3.png"), new ResourceLocation("botania:textures/misc/planet4.png"), new ResourceLocation("botania:textures/misc/planet5.png")};

    public static void renderExtra(MatrixStack ms, ClientWorld world, float partialTicks, float insideVoid) {
        float celAng;
        Tessellator tessellator = Tessellator.func_178181_a();
        float rain = 1.0f - world.func_72867_j(partialTicks);
        float effCelAng = celAng = world.func_242415_f(partialTicks);
        if ((double)celAng > 0.5) {
            effCelAng = 0.5f - (celAng - 0.5f);
        }
        float scale = 20.0f;
        float lowA = Math.max(0.0f, effCelAng - 0.3f) * rain;
        float a = Math.max(0.1f, lowA);
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        ms.func_227860_a_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(a * 4.0f * (1.0f - insideVoid)));
        ms.func_227863_a_(new Vector3f(0.5f, 0.5f, 0.0f).func_229187_a_(90.0f));
        block11: for (int p = 0; p < planetTextures.length; ++p) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(planetTextures[p]);
            Matrix4f mat = ms.func_227866_c_().func_227870_a_();
            tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
            tessellator.func_178180_c().func_227888_a_(mat, -scale, 100.0f, -scale).func_225583_a_(0.0f, 0.0f).func_181675_d();
            tessellator.func_178180_c().func_227888_a_(mat, scale, 100.0f, -scale).func_225583_a_(1.0f, 0.0f).func_181675_d();
            tessellator.func_178180_c().func_227888_a_(mat, scale, 100.0f, scale).func_225583_a_(1.0f, 1.0f).func_181675_d();
            tessellator.func_178180_c().func_227888_a_(mat, -scale, 100.0f, scale).func_225583_a_(0.0f, 1.0f).func_181675_d();
            tessellator.func_78381_a();
            switch (p) {
                case 0: {
                    ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(70.0f));
                    scale = 12.0f;
                    continue block11;
                }
                case 1: {
                    ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(120.0f));
                    scale = 15.0f;
                    continue block11;
                }
                case 2: {
                    ms.func_227863_a_(new Vector3f(1.0f, 0.0f, 1.0f).func_229187_a_(80.0f));
                    scale = 25.0f;
                    continue block11;
                }
                case 3: {
                    ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(100.0f));
                    scale = 10.0f;
                    continue block11;
                }
                case 4: {
                    ms.func_227863_a_(new Vector3f(1.0f, 0.0f, 0.5f).func_229187_a_(-60.0f));
                    scale = 40.0f;
                }
            }
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ms.func_227865_b_();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(textureSkybox);
        scale = 20.0f;
        a = lowA;
        ms.func_227860_a_();
        RenderSystem.blendFuncSeparate((int)770, (int)1, (int)1, (int)0);
        ms.func_227861_a_(0.0, -1.0, 0.0);
        ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(220.0f));
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)a);
        int angles = 90;
        float y = 2.0f;
        float y0 = 0.0f;
        float uPer = 0.0027777778f;
        float anglePer = 360.0f / (float)angles;
        double fuzzPer = Math.PI * 10 / (double)angles;
        float rotSpeed = 1.0f;
        float rotSpeedMod = 0.4f;
        block12: for (int p = 0; p < 3; ++p) {
            float baseAngle = rotSpeed * rotSpeedMod * ((float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks);
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(((float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks) * 0.25f * rotSpeed * rotSpeedMod));
            Matrix4f mat = ms.func_227866_c_().func_227870_a_();
            tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
            for (int i = 0; i < angles; ++i) {
                int j = i;
                if (i % 2 == 0) {
                    --j;
                }
                float ang = (float)j * anglePer + baseAngle;
                float xp = (float)Math.cos((double)ang * Math.PI / 180.0) * scale;
                float zp = (float)Math.sin((double)ang * Math.PI / 180.0) * scale;
                float yo = (float)Math.sin(fuzzPer * (double)j) * 1.0f;
                float ut = ang * uPer;
                if (i % 2 == 0) {
                    tessellator.func_178180_c().func_227888_a_(mat, xp, yo + y0 + y, zp).func_225583_a_(ut, 1.0f).func_181675_d();
                    tessellator.func_178180_c().func_227888_a_(mat, xp, yo + y0, zp).func_225583_a_(ut, 0.0f).func_181675_d();
                    continue;
                }
                tessellator.func_178180_c().func_227888_a_(mat, xp, yo + y0, zp).func_225583_a_(ut, 0.0f).func_181675_d();
                tessellator.func_178180_c().func_227888_a_(mat, xp, yo + y0 + y, zp).func_225583_a_(ut, 1.0f).func_181675_d();
            }
            tessellator.func_78381_a();
            switch (p) {
                case 0: {
                    ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(20.0f));
                    RenderSystem.color4f((float)1.0f, (float)0.4f, (float)0.4f, (float)a);
                    fuzzPer = 43.982297150257104 / (double)angles;
                    rotSpeed = 0.2f;
                    continue block12;
                }
                case 1: {
                    ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(50.0f));
                    RenderSystem.color4f((float)0.4f, (float)1.0f, (float)0.7f, (float)a);
                    fuzzPer = Math.PI * 6 / (double)angles;
                    rotSpeed = 2.0f;
                }
            }
        }
        ms.func_227865_b_();
        ms.func_227860_a_();
        GlStateManager.func_227644_a_((int)770, (int)771, (int)1, (int)0);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(textureRainbow);
        scale = 10.0f;
        float effCelAng1 = celAng;
        if (effCelAng1 > 0.25f) {
            effCelAng1 = 1.0f - effCelAng1;
        }
        effCelAng1 = 0.25f - Math.min(0.25f, effCelAng1);
        long time = world.func_72820_D() + 1000L;
        int day = (int)(time / 24000L);
        Random rand = new Random(day * 255);
        float angle1 = rand.nextFloat() * 360.0f;
        float angle2 = rand.nextFloat() * 360.0f;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(effCelAng1 * (1.0f - insideVoid)));
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angle1));
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(angle2));
        Matrix4f mat = ms.func_227866_c_().func_227870_a_();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (int i = 0; i < angles; ++i) {
            int j = i;
            if (i % 2 == 0) {
                --j;
            }
            float ang = (float)j * anglePer;
            float xp = (float)Math.cos((double)ang * Math.PI / 180.0) * scale;
            float zp = (float)Math.sin((double)ang * Math.PI / 180.0) * scale;
            float yo = 0.0f;
            float ut = ang * uPer;
            if (i % 2 == 0) {
                tessellator.func_178180_c().func_227888_a_(mat, xp, yo + y0 + y, zp).func_225583_a_(ut, 1.0f).func_181675_d();
                tessellator.func_178180_c().func_227888_a_(mat, xp, yo + y0, zp).func_225583_a_(ut, 0.0f).func_181675_d();
                continue;
            }
            tessellator.func_178180_c().func_227888_a_(mat, xp, yo + y0, zp).func_225583_a_(ut, 0.0f).func_181675_d();
            tessellator.func_178180_c().func_227888_a_(mat, xp, yo + y0 + y, zp).func_225583_a_(ut, 1.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        ms.func_227865_b_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - insideVoid));
        GlStateManager.func_227644_a_((int)770, (int)1, (int)1, (int)0);
    }

    public static void renderStars(VertexFormat format, VertexBuffer starVBO, MatrixStack ms, float partialTicks) {
        float celAng;
        Minecraft mc = Minecraft.func_71410_x();
        float rain = 1.0f - mc.field_71441_e.func_72867_j(partialTicks);
        float effCelAng = celAng = mc.field_71441_e.func_242415_f(partialTicks);
        if ((double)celAng > 0.5) {
            effCelAng = 0.5f - (celAng - 0.5f);
        }
        float alpha = rain * Math.max(0.1f, effCelAng * 2.0f);
        float t = ((float)ClientTickHandler.ticksInGame + partialTicks + 2000.0f) * 0.005f;
        ms.func_227860_a_();
        starVBO.func_177359_a();
        format.func_227892_a_(0L);
        ms.func_227860_a_();
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(t * 3.0f));
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        starVBO.func_227874_a_(ms.func_227866_c_().func_227870_a_(), 7);
        ms.func_227865_b_();
        ms.func_227860_a_();
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(t));
        RenderSystem.color4f((float)0.5f, (float)1.0f, (float)1.0f, (float)alpha);
        starVBO.func_227874_a_(ms.func_227866_c_().func_227870_a_(), 7);
        ms.func_227865_b_();
        ms.func_227860_a_();
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(t * 2.0f));
        RenderSystem.color4f((float)1.0f, (float)0.75f, (float)0.75f, (float)alpha);
        starVBO.func_227874_a_(ms.func_227866_c_().func_227870_a_(), 7);
        ms.func_227865_b_();
        ms.func_227860_a_();
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(t * 3.0f));
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.25f * alpha));
        starVBO.func_227874_a_(ms.func_227866_c_().func_227870_a_(), 7);
        ms.func_227865_b_();
        ms.func_227860_a_();
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(t));
        RenderSystem.color4f((float)0.5f, (float)1.0f, (float)1.0f, (float)(0.25f * alpha));
        starVBO.func_227874_a_(ms.func_227866_c_().func_227870_a_(), 7);
        ms.func_227865_b_();
        ms.func_227860_a_();
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(t * 2.0f));
        RenderSystem.color4f((float)1.0f, (float)0.75f, (float)0.75f, (float)(0.25f * alpha));
        starVBO.func_227874_a_(ms.func_227866_c_().func_227870_a_(), 7);
        ms.func_227865_b_();
        ms.func_227865_b_();
        VertexBuffer.func_177361_b();
        format.func_227895_d_();
    }
}

