/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.patchouli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;
import vazkii.botania.common.Botania;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.patchouli.api.IVariable;

public class PatchouliUtils {
    private static boolean crafttweakerInfoNote = false;

    public static <T extends IRecipe<C>, C extends IInventory> T getRecipe(IRecipeType<T> type, ResourceLocation id) {
        Map map = ModRecipeTypes.getRecipes((World)Minecraft.func_71410_x().field_71441_e, type);
        IRecipe r = map.get(id);
        if (r != null) {
            return (T)r;
        }
        r = map.get(new ResourceLocation("crafttweaker", id.func_110623_a()));
        if (r != null) {
            return (T)r;
        }
        r = map.get(new ResourceLocation("crafttweaker", "autogenerated/" + id.func_110624_b() + "." + id.func_110623_a()));
        if (r != null) {
            return (T)r;
        }
        Botania.LOGGER.warn("Template references nonexistent recipe {} of type {}", (Object)id, type);
        if (!crafttweakerInfoNote) {
            crafttweakerInfoNote = true;
            if (ModList.get().isLoaded("crafttweaker")) {
                Botania.LOGGER.info("To add a recipe that replaces a builtin recipe with CT, \nadd one with the same type, named the same as the path of the missing recipe.\neg. for recipe {}, add a recipe named \"{}\".", (Object)id, (Object)id.func_110623_a());
            }
        }
        return null;
    }

    public static <T extends IRecipe<C>, C extends IInventory> List<T> getRecipeGroup(IRecipeType<T> type, String group) {
        Map map = ModRecipeTypes.getRecipes((World)Minecraft.func_71410_x().field_71441_e, type);
        ArrayList list = new ArrayList();
        for (IRecipe value : map.values()) {
            if (!group.equals(value.func_193358_e())) continue;
            list.add(value);
        }
        if (list.isEmpty()) {
            Botania.LOGGER.warn("Template references empty group {} of recipe type {}", (Object)group, type);
        }
        return list;
    }

    public static IVariable interweaveIngredients(List<Ingredient> ingredients, int longestIngredientSize) {
        if (ingredients.size() == 1) {
            return IVariable.wrapList((Iterable)Arrays.stream(ingredients.get(0).func_193365_a()).map(IVariable::from).collect(Collectors.toList()));
        }
        ItemStack[] empty = new ItemStack[]{ItemStack.field_190927_a};
        ArrayList<ItemStack[]> stacks = new ArrayList<ItemStack[]>();
        for (Ingredient ingredient : ingredients) {
            if (ingredient != null && !ingredient.func_203189_d()) {
                stacks.add(ingredient.func_193365_a());
                continue;
            }
            stacks.add(empty);
        }
        ArrayList<IVariable> list = new ArrayList<IVariable>(stacks.size() * longestIngredientSize);
        for (int i = 0; i < longestIngredientSize; ++i) {
            for (ItemStack[] stack : stacks) {
                list.add(IVariable.from((Object)stack[i % stack.length]));
            }
        }
        return IVariable.wrapList(list);
    }

    public static IVariable interweaveIngredients(List<Ingredient> ingredients) {
        return PatchouliUtils.interweaveIngredients(ingredients, ingredients.stream().mapToInt(ingr -> ingr.func_193365_a().length).max().orElse(1));
    }
}

