/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.block.Blocks;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector2f;
import vazkii.botania.api.recipe.ITerraPlateRecipe;
import vazkii.botania.client.core.handler.HUDHandler;
import vazkii.botania.client.integration.jei.PetalApothecaryRecipeCategory;
import vazkii.botania.client.integration.jei.TerraPlateDrawable;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class TerraPlateRecipeCategory
implements IRecipeCategory<ITerraPlateRecipe> {
    public static final ResourceLocation UID = ResourceLocationHelper.prefix("terra_plate");
    private final String localizedName;
    private final IDrawable background;
    private final IDrawable overlay;
    private final IDrawable icon;
    private final IDrawable terraPlate;

    public TerraPlateRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = ResourceLocationHelper.prefix("textures/gui/terrasteel_jei_overlay.png");
        this.background = guiHelper.createBlankDrawable(114, 131);
        this.overlay = guiHelper.createDrawable(location, 42, 29, 64, 64);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.terraPlate));
        this.localizedName = I18n.func_135052_a((String)"botania.nei.terraPlate", (Object[])new Object[0]);
        IDrawable livingrock = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.livingrock));
        this.terraPlate = new TerraPlateDrawable(livingrock, livingrock, guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)Blocks.field_150368_y)));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends ITerraPlateRecipe> getRecipeClass() {
        return ITerraPlateRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(@Nonnull ITerraPlateRecipe recipe, @Nonnull MatrixStack ms, double mouseX, double mouseY) {
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        this.overlay.draw(ms, 25, 14);
        HUDHandler.renderManaBar(ms, 6, 126, 255, 0.75f, recipe.getMana(), 100000);
        this.terraPlate.draw(ms, 35, 92);
        RenderSystem.disableBlend();
        RenderSystem.disableAlphaTest();
    }

    public void setIngredients(@Nonnull ITerraPlateRecipe recipe, @Nonnull IIngredients iIngredients) {
        ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>();
        for (Ingredient ingr : recipe.func_192400_c()) {
            list.add(Arrays.asList(ingr.func_193365_a()));
        }
        iIngredients.setInputLists(VanillaTypes.ITEM, list);
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(@Nonnull IRecipeLayout layout, @Nonnull ITerraPlateRecipe recipe, @Nonnull IIngredients ingredients) {
        layout.getItemStacks().init(0, false, 48, 37);
        layout.getItemStacks().set(0, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        int index = 1;
        double angleBetweenEach = 360.0 / (double)ingredients.getInputs(VanillaTypes.ITEM).size();
        Vector2f point = new Vector2f(48.0f, 5.0f);
        Vector2f center = new Vector2f(48.0f, 37.0f);
        for (List o : ingredients.getInputs(VanillaTypes.ITEM)) {
            layout.getItemStacks().init(index, true, (int)point.field_189982_i, (int)point.field_189983_j);
            layout.getItemStacks().set(index, o);
            ++index;
            point = PetalApothecaryRecipeCategory.rotatePointAbout(point, center, angleBetweenEach);
        }
        layout.getItemStacks().init(index, true, 48, 92);
        layout.getItemStacks().set(index, new ItemStack((IItemProvider)ModBlocks.terraPlate));
    }
}

