/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.items;

import com.endertech.common.CommonCollect;
import com.endertech.common.CommonTime;
import com.endertech.common.FloatBounds;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemGroup
extends net.minecraft.item.ItemGroup {
    protected ItemStack icon = ItemStack.field_190927_a;
    protected CommonTime.Stamp lastChange = CommonTime.Stamp.now();
    protected CommonTime.Interval changeInterval = CommonTime.Interval.ZERO;
    protected FloatBounds seconds = FloatBounds.from(Float.valueOf(0.0f));

    public ItemGroup(String label) {
        super(label);
    }

    public static ItemGroup labeled(String label) {
        return new ItemGroup(label);
    }

    public ItemGroup icon(Item item) {
        this.icon = new ItemStack((IItemProvider)item);
        return this;
    }

    public ItemGroup changeEvery(float minSeconds, float maxSeconds) {
        this.seconds = FloatBounds.from(Float.valueOf(minSeconds), Float.valueOf(maxSeconds));
        this.updateInterval();
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_78016_d() {
        return this.icon;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_151244_d() {
        if (!this.changeInterval.equals(CommonTime.Interval.ZERO) && CommonTime.Interval.passedFrom(this.lastChange).moreThan(this.changeInterval)) {
            NonNullList items = NonNullList.func_191196_a();
            this.func_78018_a(items);
            this.icon = (ItemStack)CommonCollect.getRandomElementFrom(items);
            if (this.icon == null) {
                this.icon = ItemStack.field_190927_a;
            }
            this.lastChange = CommonTime.Stamp.now();
            this.updateInterval();
        }
        return this.icon;
    }

    protected void updateInterval() {
        this.changeInterval = CommonTime.Interval.seconds(this.seconds.randomBetween().floatValue());
    }
}

