/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.events;

import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class BlockStateChangeEvent
extends Event {
    private final ServerWorld world;
    private final BlockPos pos;
    private final BlockState oldState;
    private final BlockState newState;

    public BlockStateChangeEvent(ServerWorld world, BlockPos pos, BlockState oldState, BlockState newState) {
        this.world = world;
        this.pos = pos;
        this.oldState = oldState;
        this.newState = newState;
    }

    public ServerWorld getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public BlockState getOldState() {
        return this.oldState;
    }

    public BlockState getNewState() {
        return this.newState;
    }

    public static void onBlockStateChange(ServerWorld world, BlockPos pos, BlockState oldState, BlockState newState) {
        MinecraftForge.EVENT_BUS.post((Event)new BlockStateChangeEvent(world, pos, oldState, newState));
    }
}

