/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.configs;

import com.endertech.common.Args;
import com.endertech.common.CommonMath;
import com.endertech.common.CommonTime;
import com.endertech.common.FloatBounds;
import com.endertech.common.IBounds;
import com.endertech.common.IntBounds;
import com.endertech.common.KeyValuePair;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.Configuration;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.data.Names;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class UnitConfig
extends Configuration {
    public static final String EXTENSION = ".cfg";
    public static final String KEY_LIST = "list";

    public UnitConfig(File file) {
        super(file, true);
        this.load();
    }

    public static UnitConfig in(Path baseDir, String folderName, String configName) {
        return new UnitConfig(UnitConfig.buildPath(baseDir, folderName, configName).toFile());
    }

    public static UnitConfig in(Path baseDir, String configName) {
        return new UnitConfig(UnitConfig.buildPath(baseDir, configName).toFile());
    }

    public static Path buildPath(Path baseDir, String folderName, String configName) {
        baseDir = Paths.get(String.valueOf(baseDir), folderName);
        return UnitConfig.buildPath(baseDir, configName);
    }

    public static Path buildPath(Path baseDir, String configName) {
        return Paths.get(String.valueOf(baseDir), configName + EXTENSION);
    }

    public static boolean alreadyExists(Path baseDir, String configName) {
        Path path = UnitConfig.buildPath(baseDir, configName);
        return path.toFile().isFile();
    }

    public static List<Path> listCustomConfigs(Path searchDir, @Nullable Class<? extends IForgeEnum> exclude) {
        ArrayList<String> excludeList = new ArrayList<String>();
        if (exclude != null) {
            for (IForgeEnum e : exclude.getEnumConstants()) {
                excludeList.add(e.getName() + EXTENSION);
            }
        }
        ArrayList<Path> configList = new ArrayList<Path>();
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(searchDir, "*.cfg");){
            for (Path path : dirStream) {
                if (excludeList.contains(String.valueOf(path.getFileName()))) continue;
                configList.add(path);
            }
        }
        catch (Exception e) {
            ForgeEndertech.getInstance().getLogger().error(e.toString());
        }
        return configList;
    }

    public static boolean readConfigEnabled(UnitConfig config, boolean defaultValue) {
        boolean enabled = UnitConfig.getBool(config, "Config", "enabled", defaultValue, "If set to False, parameters from this config will not be used.");
        return enabled;
    }

    public static String getDescription(String param, String description, boolean addCR) {
        return param + " " + description + (addCR ? "\n" : "");
    }

    public static String getSyntax(Object ... args) {
        return "Syntax: " + Args.join(args);
    }

    public static boolean getBool(UnitConfig config, String category, String key, boolean defaultValue, String comment) {
        if (config != null) {
            return config.getBool(category, key, defaultValue, comment);
        }
        return defaultValue;
    }

    public static int getInt(UnitConfig config, String category, String key, int defaultValue, IntBounds bounds, String comment) {
        if (config != null) {
            return config.getInt(category, key, defaultValue, bounds, comment);
        }
        return CommonMath.Range.enclose(defaultValue, bounds);
    }

    public static IntBounds getIntBounds(UnitConfig config, String category, String caption, IntBounds defaultValue, IntBounds bounds, String comment) {
        if (config != null) {
            return config.getIntBounds(category, caption, defaultValue, bounds, comment);
        }
        return defaultValue.fit((IBounds)bounds);
    }

    public static float getFloat(UnitConfig config, String category, String key, float defaultValue, FloatBounds bounds, String comment) {
        if (config != null) {
            return config.getFloat(category, key, defaultValue, bounds, comment);
        }
        return CommonMath.Range.enclose(defaultValue, bounds);
    }

    public static FloatBounds getFloatBounds(UnitConfig config, String category, String caption, FloatBounds defaultValue, FloatBounds bounds, String comment) {
        if (config != null) {
            return config.getFloatBounds(category, caption, defaultValue, bounds, comment);
        }
        return defaultValue.fit((IBounds)bounds);
    }

    public static Percentage getPercentage(UnitConfig config, String category, String key, Percentage defaultValue, FloatBounds bounds, String comment) {
        if (config != null) {
            return config.getPercentage(category, key, defaultValue, bounds, comment);
        }
        float value = bounds.enclose(Float.valueOf(defaultValue.getValue())).floatValue();
        return new Percentage(value);
    }

    public static String getStr(UnitConfig config, String category, String key, String defaultValue, String comment) {
        if (config != null) {
            return config.getStr(category, key, defaultValue, comment);
        }
        return defaultValue;
    }

    public static ColorARGB getColorARGB(UnitConfig config, String category, String key, ColorARGB defaultValue, String comment) {
        if (config != null) {
            return config.getColorARGB(category, key, defaultValue, comment);
        }
        return defaultValue;
    }

    public static KeyValuePair getKeyValuePair(UnitConfig config, String category, String key, KeyValuePair defaultValue, String comment) {
        if (config != null) {
            return config.getKeyValuePair(category, key, defaultValue, comment);
        }
        return defaultValue;
    }

    public static UnitId getUnitId(UnitConfig config, String category, String key, UnitId defaultValue, String comment) {
        if (config != null) {
            return config.getUnitId(category, key, defaultValue, comment);
        }
        return defaultValue;
    }

    public static CommonTime.Interval getTimeInSeconds(UnitConfig config, String category, String key, CommonTime.Interval defaultValue, String comment) {
        if (config != null) {
            return config.getTimeInSeconds(category, key, defaultValue, comment);
        }
        return defaultValue;
    }

    public static CommonTime.Interval getTimeInMillis(UnitConfig config, String category, String key, CommonTime.Interval defaultValue, String comment) {
        if (config != null) {
            return config.getTimeInMillis(category, key, defaultValue, comment);
        }
        return defaultValue;
    }

    public static String[] getStrArray(UnitConfig config, String category, String key, String[] defaultValues, String comment) {
        if (config != null) {
            return config.getStrArray(category, key, defaultValues, comment);
        }
        return defaultValues;
    }

    public static void save(UnitConfig config) {
        if (config != null && config.hasChanged()) {
            config.save();
        }
    }

    public boolean getBool(String category, String key, boolean defaultValue, String comment) {
        try {
            return this.getBoolean(key, category, defaultValue, comment);
        }
        catch (Exception e) {
            this.getLogger().error(e.toString());
            return defaultValue;
        }
    }

    public int getInt(String category, String key, int defaultValue, IntBounds bounds, String comment) {
        try {
            return this.getInt(key, category, defaultValue, bounds.getMin(), bounds.getMax(), comment);
        }
        catch (Exception e) {
            this.getLogger().error(e.toString());
            return CommonMath.Range.enclose(defaultValue, bounds);
        }
    }

    public IntBounds getIntBounds(String category, String caption, IntBounds defaultValue, IntBounds bounds, String comment) {
        category = Names.dotted().join(category, caption);
        this.setCategoryComment(category, comment);
        int min = this.getInt(category, "min", defaultValue.min, bounds, "");
        int max = this.getInt(category, "max", defaultValue.max, bounds, "");
        return IntBounds.from(min, max);
    }

    public float getFloat(String category, String key, float defaultValue, FloatBounds bounds, String comment) {
        try {
            return this.getFloat(key, category, defaultValue, bounds.getMin().floatValue(), bounds.getMax().floatValue(), comment);
        }
        catch (Exception e) {
            this.getLogger().error(e.toString());
            return CommonMath.Range.enclose(defaultValue, bounds);
        }
    }

    public FloatBounds getFloatBounds(String category, String caption, FloatBounds defaultValue, FloatBounds bounds, String comment) {
        category = Names.dotted().join(category, caption);
        this.setCategoryComment(category, comment);
        float min = this.getFloat(category, "min", defaultValue.min.floatValue(), bounds, "");
        float max = this.getFloat(category, "max", defaultValue.max.floatValue(), bounds, "");
        return FloatBounds.from(Float.valueOf(min), Float.valueOf(max));
    }

    public Percentage getPercentage(String category, String key, Percentage defaultValue, FloatBounds bounds, String comment) {
        float value = this.getFloat(category, key, defaultValue.getValue(), bounds, comment);
        return new Percentage(value);
    }

    public String getStr(String category, String key, String defaultValue, String comment) {
        try {
            return this.getString(key, category, defaultValue, comment);
        }
        catch (Exception e) {
            this.getLogger().error(e.toString());
            return defaultValue;
        }
    }

    public ColorARGB getColorARGB(String category, String key, ColorARGB defaultValue, String comment) {
        String hexARGB = this.getStr(category, key, defaultValue.getHexARGB(), comment);
        return ColorARGB.from(hexARGB);
    }

    public KeyValuePair getKeyValuePair(String category, String key, KeyValuePair defaultValue, String comment) {
        String str = this.getStr(category, key, defaultValue.toString(), comment);
        return KeyValuePair.from(str);
    }

    public UnitId getUnitId(String category, String key, UnitId defaultValue, String comment) {
        String stringId = this.getStr(category, key, defaultValue.toString(), comment);
        return UnitId.from(stringId);
    }

    public CommonTime.Interval getTimeInSeconds(String category, String key, CommonTime.Interval defaultValue, String comment) {
        float seconds = this.getFloat(category, key, (float)defaultValue.inSeconds(), FloatBounds.from(Float.valueOf(0.0f), Float.valueOf(86400.0f)), comment + " [in seconds]");
        return CommonTime.Interval.seconds(seconds);
    }

    public CommonTime.Interval getTimeInMillis(String category, String key, CommonTime.Interval defaultValue, String comment) {
        int milliseconds = this.getInt(category, key, (int)defaultValue.inMillis(), IntBounds.INTEGER_POSITIVE, comment + " [in milliseconds]");
        return CommonTime.Interval.millis(milliseconds);
    }

    public String[] getStrArray(String category, String key, String[] defaultValues, String comment) {
        try {
            return this.getStringList(key, category, defaultValues, comment);
        }
        catch (Exception e) {
            this.getLogger().error(e.toString());
            return defaultValues;
        }
    }

    public Path getConfigDir() {
        return this.getConfigFile().getParentFile().toPath();
    }

    @Override
    public void save() {
        if (this.hasChanged()) {
            super.save();
        }
    }
}

