/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.blocks;

import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public abstract class ForgeTiledBlock<T extends TileEntity>
extends ForgeBlock {
    protected final Class<T> tileClass;

    public ForgeTiledBlock(ForgeMod mod, UnitConfig config, ForgeBlock.Properties<?> props, Class<T> tileClass) {
        super(mod, config, props);
        this.tileClass = tileClass;
    }

    public abstract T createTile(IBlockReader var1, BlockState var2);

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public Optional<T> getTile(IBlockReader world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return this.tileClass.isInstance(tile) ? Optional.of((TileEntity)this.tileClass.cast(tile)) : Optional.empty();
    }

    public final TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return this.createTile(world, state);
    }
}

