/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.tiles.tooltip.own;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.zeith.hammerlib.tiles.tooltip.own.GuiTooltip;
import org.zeith.hammerlib.tiles.tooltip.own.ITooltipProviderHC;

@OnlyIn(value=Dist.CLIENT)
public class EntityTooltipRenderEngine {
    public BlockPos lastPos;
    public UUID lastEntity;
    public GuiTooltip lastTooltip;

    public EntityTooltipRenderEngine() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void renderWorldLast(RenderGameOverlayEvent.Post e) {
        if (e.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            RayTraceResult res = Minecraft.func_71410_x().field_71476_x;
            if (res != null) {
                ITooltipProviderHC prov = null;
                if (res.func_216346_c() == RayTraceResult.Type.BLOCK && res instanceof BlockRayTraceResult) {
                    boolean diffPos;
                    ClientWorld wc = Minecraft.func_71410_x().field_71441_e;
                    BlockPos bp = ((BlockRayTraceResult)res).func_216350_a();
                    Block bl = wc.func_180495_p(bp).func_177230_c();
                    TileEntity tl = wc.func_175625_s(bp);
                    if (tl instanceof ITooltipProviderHC) {
                        prov = (ITooltipProviderHC)tl;
                    } else if (bl instanceof ITooltipProviderHC) {
                        prov = (ITooltipProviderHC)bl;
                    }
                    boolean bl2 = diffPos = !Objects.equals(bp, this.lastPos);
                    if (diffPos) {
                        this.lastPos = bp;
                        this.lastTooltip = null;
                    }
                    if (prov != null && (diffPos || prov.isTooltipDirty())) {
                        prov.setTooltipDirty(false);
                        this.lastTooltip = new GuiTooltip().withLocation((World)wc, bp).withProvider(prov);
                    }
                } else if (res.func_216346_c() == RayTraceResult.Type.ENTITY && res instanceof EntityRayTraceResult && ((EntityRayTraceResult)res).func_216348_a() instanceof ITooltipProviderHC) {
                    boolean diffEntity;
                    Entity ent = ((EntityRayTraceResult)res).func_216348_a();
                    prov = (ITooltipProviderHC)ent;
                    boolean bl = diffEntity = !Objects.equals(ent.func_110124_au(), this.lastEntity);
                    if (diffEntity) {
                        this.lastEntity = ent.func_110124_au();
                        this.lastTooltip = null;
                    }
                    if (diffEntity || prov.isTooltipDirty()) {
                        prov.setTooltipDirty(false);
                        this.lastTooltip = new GuiTooltip().withEntity(ent).withProvider(prov);
                    }
                } else {
                    this.lastPos = null;
                    this.lastTooltip = null;
                }
            } else {
                this.lastPos = null;
                this.lastTooltip = null;
            }
            if (this.lastTooltip != null) {
                int sw = e.getWindow().func_198107_o();
                int sh = e.getWindow().func_198087_p();
                float cx = (float)sw / 2.0f + 12.0f;
                float cy = ((float)sh - (float)this.lastTooltip.getHeight()) / 2.0f + 2.0f;
                float pt = e.getPartialTicks();
                this.lastTooltip.render(e.getMatrixStack(), cx, cy, pt);
            }
        }
    }
}

