/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.proxy;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.resources.ClientLanguageMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;
import org.objectweb.asm.Type;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.api.LanguageHelper;
import org.zeith.hammerlib.api.forge.ContainerAPI;
import org.zeith.hammerlib.api.inv.IScreenContainer;
import org.zeith.hammerlib.api.lighting.ColoredLight;
import org.zeith.hammerlib.api.lighting.HandleLightOverrideEvent;
import org.zeith.hammerlib.api.lighting.impl.IGlowingEntity;
import org.zeith.hammerlib.client.render.tile.ITESR;
import org.zeith.hammerlib.client.render.tile.TESRBase;
import org.zeith.hammerlib.event.ResourceManagerReloadEvent;
import org.zeith.hammerlib.net.Network;
import org.zeith.hammerlib.net.packets.PingServerPacket;
import org.zeith.hammerlib.proxy.HLCommonProxy;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.ReflectionUtil;
import org.zeith.hammerlib.util.mcf.LogicalSidePredictor;

public class HLClientProxy
extends HLCommonProxy {
    public static Map<IParticleRenderType, Queue<Particle>> PARTICLE_MAP;
    private Map<String, String> languageList;
    int pingTimer;
    private boolean renderF3;

    @Override
    public void applyLang(LanguageHelper.LangMap lmap) {
        LanguageMap langMap = I18n.field_239501_a_;
        if (langMap instanceof ClientLanguageMap) {
            ClientLanguageMap clm = (ClientLanguageMap)langMap;
            if (clm.field_239495_c_ instanceof ImmutableMap) {
                clm.field_239495_c_ = new HashMap(clm.field_239495_c_);
            }
            this.languageList = clm.field_239495_c_;
        }
        try {
            lmap.apply(this.languageList);
        }
        catch (UnsupportedOperationException uoe) {
            uoe.printStackTrace();
        }
    }

    @Override
    public void clientSetup() {
        ScreenManager.func_216911_a(ContainerAPI.TILE_CONTAINER, (ctr, inv, txt) -> Cast.optionally(ctr, IScreenContainer.class).map(c -> c.openScreen(inv, txt)).orElse(null));
        this.getResourceManager().func_219534_a((IFutureReloadListener)((ISelectiveResourceReloadListener)(resourceManager, resourcePredicate) -> {
            if (resourcePredicate.test(VanillaResourceType.LANGUAGES)) {
                LanguageHelper.reloadLanguage();
            }
            MinecraftForge.EVENT_BUS.post((Event)new ResourceManagerReloadEvent(resourcePredicate, resourceManager));
        }));
        PARTICLE_MAP = ReflectionUtil.getField(Minecraft.func_71410_x().field_71452_i, 2, Map.class).orElseGet(Collections::emptyMap);
    }

    public static Stream<Particle> streamParticles() {
        return PARTICLE_MAP.values().stream().flatMap(Collection::stream);
    }

    @Override
    public Stream<ColoredLight> getGlowingParticles(float partialTicks) {
        return HLClientProxy.streamParticles().map(particle -> {
            ColoredLight l = null;
            IGlowingEntity ent = Cast.cast(Float.valueOf(partialTicks), IGlowingEntity.class);
            if (ent != null) {
                l = ent.produceColoredLight(partialTicks);
            }
            HandleLightOverrideEvent<Particle> evt = new HandleLightOverrideEvent<Particle>((Particle)particle, partialTicks, l);
            MinecraftForge.EVENT_BUS.post(evt);
            return evt.getNewLight();
        }).filter((Predicate<ColoredLight>)Predicates.notNull());
    }

    @Override
    public Consumer<FMLClientSetupEvent> addTESR(Class<?> owner, String member, Type tesr) {
        return e -> ReflectionUtil.getStaticFinalField(owner, member).ifPresent(type -> {
            if (type.getRegistryName() == null) {
                HammerLib.LOG.info("Skipping TESR for tile " + type.getRegistryName() + " as it is not registered.");
                return;
            }
            HammerLib.LOG.info("Registering TESR for tile " + type.getRegistryName());
            Class anyTesr = ReflectionUtil.fetchClass(tesr);
            TileEntityRendererDispatcher terd = TileEntityRendererDispatcher.field_147556_a;
            TileEntityRenderer theTesr = null;
            if (ITESR.class.isAssignableFrom(anyTesr)) {
                try {
                    Constructor ctor = anyTesr.getDeclaredConstructor(new Class[0]);
                    ctor.setAccessible(true);
                    theTesr = new TESRBase(terd, (ITESR)ctor.newInstance(new Object[0]));
                }
                catch (ReflectiveOperationException err) {
                    err.printStackTrace();
                }
            }
            if (theTesr == null) {
                for (Constructor<?> ctr : anyTesr.getDeclaredConstructors()) {
                    try {
                        if (ctr.getParameterCount() == 0) {
                            theTesr = (TileEntityRenderer)ctr.newInstance(new Object[0]);
                            continue;
                        }
                        if (ctr.getParameterCount() != 1 || ctr.getParameterTypes()[0] != TileEntityRendererDispatcher.class) continue;
                        theTesr = (TileEntityRenderer)ctr.newInstance(terd);
                    }
                    catch (ReflectiveOperationException err) {
                        err.printStackTrace();
                    }
                }
            }
            if (theTesr == null) {
                throw new RuntimeException("Unable to find a valid constructor for " + type.getRegistryName() + "'s TESR " + anyTesr);
            }
            terd.setSpecialRendererInternal(type, (TileEntityRenderer)Cast.cast(theTesr));
        });
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            LanguageHelper.update();
        }
        if (Minecraft.func_71410_x().field_71441_e != null && !Minecraft.func_71410_x().func_147113_T()) {
            --this.pingTimer;
            if (this.pingTimer <= 0) {
                this.pingTimer += 40;
                Network.sendToServer(new PingServerPacket(System.currentTimeMillis()));
            }
        }
    }

    @SubscribeEvent
    public void addF3Info(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.DEBUG) {
            this.renderF3 = true;
        }
    }

    @SubscribeEvent
    public void addF3Info(RenderGameOverlayEvent.Text f3) {
        if (this.renderF3) {
            ArrayList tip = f3.getLeft();
            tip.add(TextFormatting.GOLD + "[HammerLib]" + TextFormatting.RESET + " Ping: ~" + PingServerPacket.lastPingTime + " ms.");
            this.renderF3 = false;
        }
    }

    @Override
    public String getLanguage() {
        return Minecraft.func_71410_x().field_71474_y.field_74363_ab;
    }

    @Override
    public PlayerEntity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public IReloadableResourceManager getResourceManager() {
        if (LogicalSidePredictor.getCurrentLogicalSide() == LogicalSide.CLIENT) {
            return (IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G();
        }
        return super.getResourceManager();
    }
}

