/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.properties;

import java.util.Objects;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import org.zeith.hammerlib.net.properties.IProperty;
import org.zeith.hammerlib.net.properties.PropertyDispatcher;
import org.zeith.hammerlib.util.java.DirectStorage;

public class PropertyResourceLocation
implements IProperty<ResourceLocation> {
    final DirectStorage<ResourceLocation> value;
    boolean changed;
    PropertyDispatcher dispatcher;

    public PropertyResourceLocation(DirectStorage<ResourceLocation> value) {
        this.value = value;
    }

    public PropertyResourceLocation() {
        this(DirectStorage.allocate());
    }

    @Override
    public Class<ResourceLocation> getType() {
        return ResourceLocation.class;
    }

    @Override
    public ResourceLocation set(ResourceLocation value) {
        ResourceLocation pv = this.value.get();
        if (!Objects.equals(pv, value)) {
            this.value.set(value);
            this.markChanged(true);
        }
        return pv;
    }

    @Override
    public void markChanged(boolean changed) {
        this.changed = changed;
        if (changed) {
            this.notifyDispatcherOfChange();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public void write(PacketBuffer buf) {
        ResourceLocation value = this.value.get();
        buf.writeBoolean(value != null);
        if (value != null) {
            buf.func_192572_a(value);
        }
    }

    @Override
    public void read(PacketBuffer buf) {
        this.value.set(buf.readBoolean() ? buf.func_192575_l() : null);
    }

    @Override
    public ResourceLocation get() {
        return this.value.get();
    }

    @Override
    public PropertyDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public void setDispatcher(PropertyDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }
}

