/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.pipelines.shaders;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.zeith.hammerlib.client.pipelines.shaders.ShaderVar;
import org.zeith.hammerlib.util.java.IOUtils;
import org.zeith.hammerlib.util.java.itf.IThrowableSupplier;

@OnlyIn(value=Dist.CLIENT)
public class ShaderSource {
    String toString;
    IThrowableSupplier<InputStream, IOException> ioGenerator;

    public ShaderSource(ResourceLocation path) {
        this(() -> Minecraft.func_71410_x().func_195551_G().func_199002_a(path).func_199027_b());
        this.toString = "resource='" + path + '\'';
    }

    public ShaderSource(IThrowableSupplier<InputStream, IOException> ioGenerator) {
        this.ioGenerator = ioGenerator;
        this.toString = "ioGenerator=" + ioGenerator;
    }

    public String read(List<ShaderVar> variables) {
        String str = "";
        try (InputStream in = this.ioGenerator.get();){
            str = new String(IOUtils.pipeOut(in), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (ShaderVar var : variables) {
            str = str.replaceAll("#variable " + var.key, var.getValue()).replaceAll("%" + var.key + "%", var.getValue());
        }
        return str;
    }

    public String toString() {
        return "ShaderSource{" + this.toString + "}";
    }
}

