/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.items;

import java.util.Arrays;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import org.zeith.hammerlib.core.RecipeHelper;

public class ConsumableItem {
    public final Ingredient ingr;
    public final int amount;

    public static ConsumableItem of(int amount, Ingredient ... ing) {
        return new ConsumableItem(amount, ing);
    }

    public static ConsumableItem of(int amount, Item ... items) {
        return new ConsumableItem(amount, Ingredient.func_199804_a((IItemProvider[])items));
    }

    public static ConsumableItem of(int amount, ITag.INamedTag<Item> tag) {
        return new ConsumableItem(amount, RecipeHelper.fromTag(tag));
    }

    public static ConsumableItem of(int amount, ItemStack ... stacks) {
        return new ConsumableItem(amount, Ingredient.func_193369_a((ItemStack[])stacks));
    }

    public ConsumableItem(int amount, Ingredient ... ing) {
        this.amount = amount;
        this.ingr = Ingredient.merge(Arrays.asList(ing));
    }

    public boolean canConsume(IInventory inv) {
        int co = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack s = inv.func_70301_a(i);
            if (s.func_190926_b() || !this.ingr.test(s)) continue;
            co += s.func_190916_E();
        }
        return co >= this.amount;
    }

    public boolean consume(IInventory inv) {
        if (this.canConsume(inv)) {
            int co = this.amount;
            for (int i = 0; i < inv.func_70302_i_() && co > 0; ++i) {
                ItemStack s = inv.func_70301_a(i);
                if (s.func_190926_b() || !this.ingr.test(s)) continue;
                int c = Math.min(co, s.func_190916_E());
                s.func_190918_g(c);
                co -= c;
            }
            return co == 0;
        }
        return false;
    }
}

