/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.forge;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.fml.network.NetworkHooks;
import org.zeith.hammerlib.annotations.RegistryName;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.hammerlib.api.tiles.IContainerTile;
import org.zeith.hammerlib.util.java.Cast;

@SimplyRegister
public class ContainerAPI {
    @RegistryName(value="tile_container")
    public static final ContainerType<Container> TILE_CONTAINER = IForgeContainerType.create((windowId, playerInv, extraData) -> {
        TileEntity tile = playerInv.field_70458_d.field_70170_p.func_175625_s(extraData.func_179259_c());
        return Cast.optionally(tile, IContainerTile.class).map(ict -> ict.openContainer(playerInv.field_70458_d, windowId)).orElse(null);
    });

    public static INamedContainerProvider forTile(final TileEntity tile) {
        return new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return Cast.optionally(tile, IContainerTile.class).map(IContainerTile::getDisplayName).orElseGet(() -> tile.func_195044_w().func_177230_c().func_235333_g_());
            }

            @Nullable
            public Container createMenu(int windowId, PlayerInventory playerInv, PlayerEntity player) {
                return Cast.optionally(tile, IContainerTile.class).map(ict -> ict.openContainer(player, windowId)).orElse(null);
            }
        };
    }

    public static <T extends TileEntity> void openContainerTile(PlayerEntity player, T tile) {
        if (player instanceof ServerPlayerEntity && tile != null) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)ContainerAPI.forTile(tile), buf -> buf.func_179255_a(tile.func_174877_v()));
        }
    }
}

