/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.crafting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.api.crafting.IGeneralRecipe;
import org.zeith.hammerlib.api.crafting.IRecipeContainer;
import org.zeith.hammerlib.event.recipe.ReloadRecipeRegistryEvent;

public abstract class AbstractRecipeRegistry<T extends IGeneralRecipe, CTR extends IRecipeContainer<T>, IDX> {
    private static final List<AbstractRecipeRegistry<?, ?, ?>> ALL_REGISTRIES = new ArrayList();
    private static final List<AbstractRecipeRegistry<?, ?, ?>> ALL_REGISTRIES_VIEW = Collections.unmodifiableList(ALL_REGISTRIES);
    protected final Class<T> type;
    protected final CTR container;
    private final ResourceLocation id;

    public AbstractRecipeRegistry(Class<T> type, CTR container, ResourceLocation id) {
        if (HammerLib.PROXY.hasFinishedLoading()) {
            throw new IllegalStateException("Attempted to create recipe registry for type " + type.getName() + " too late! Please do it in construct or preInit!");
        }
        this.id = id;
        this.type = type;
        this.container = container;
        ALL_REGISTRIES.add(this);
    }

    public abstract IDX addRecipe(T var1);

    public abstract void removeRecipe(T var1);

    protected abstract void removeAllRecipes();

    public abstract T getRecipe(IDX var1);

    public Collection<T> getRecipes() {
        return this.container.getRecipes();
    }

    public int getRecipeCount() {
        return this.container.getRecipeCount();
    }

    public Class<T> getRecipeType() {
        return this.type;
    }

    public static List<AbstractRecipeRegistry<?, ?, ?>> getAllRegistries() {
        return ALL_REGISTRIES_VIEW;
    }

    public ResourceLocation getRegistryId() {
        return this.id;
    }

    public void reload() {
        MinecraftForge.EVENT_BUS.post((Event)new ReloadRecipeRegistryEvent.Pre(this));
        this.removeAllRecipes();
        MinecraftForge.EVENT_BUS.post(new ReloadRecipeRegistryEvent.AddRecipes(this));
        MinecraftForge.EVENT_BUS.post((Event)new ReloadRecipeRegistryEvent.Post(this));
    }
}

