/*
 * Decompiled with CFR 0.152.
 */
package eutros.framedcompactdrawers.block;

import com.google.common.collect.ImmutableList;
import com.jaquadro.minecraft.storagedrawers.client.renderer.TileEntityDrawersRenderer;
import eutros.framedcompactdrawers.FramedCompactDrawers;
import eutros.framedcompactdrawers.block.BlockCompDrawersCustom;
import eutros.framedcompactdrawers.block.BlockControllerCustom;
import eutros.framedcompactdrawers.block.BlockDrawersStandardCustom;
import eutros.framedcompactdrawers.block.BlockSlaveCustom;
import eutros.framedcompactdrawers.block.BlockTrimCustom;
import eutros.framedcompactdrawers.block.tile.TileCompDrawersCustom;
import eutros.framedcompactdrawers.block.tile.TileControllerCustom;
import eutros.framedcompactdrawers.block.tile.TileDrawersStandardCustom;
import eutros.framedcompactdrawers.block.tile.TileSlaveCustom;
import eutros.framedcompactdrawers.block.tile.TileTrimCustom;
import eutros.framedcompactdrawers.item.ItemDrawersCustom;
import eutros.framedcompactdrawers.item.ItemOtherCustom;
import eutros.framedcompactdrawers.render.RenderHelper;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModBlocks {
    public static BlockCompDrawersCustom framedCompactDrawer;
    public static BlockControllerCustom framedDrawerController;
    public static BlockSlaveCustom framedSlave;
    public static BlockTrimCustom framedTrim;
    public static BlockDrawersStandardCustom framedFullOne;
    public static BlockDrawersStandardCustom framedFullTwo;
    public static BlockDrawersStandardCustom framedFullFour;
    public static BlockDrawersStandardCustom framedHalfOne;
    public static BlockDrawersStandardCustom framedHalfTwo;
    public static BlockDrawersStandardCustom framedHalfFour;

    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry r = event.getRegistry();
        AbstractBlock.Properties properties = AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).harvestTool(ToolType.AXE).func_200943_b(5.0f).func_226896_b_();
        framedCompactDrawer = new BlockCompDrawersCustom(properties);
        r.register(framedCompactDrawer.setRegistryName("framedcompactdrawers", "framed_compact_drawer"));
        framedDrawerController = new BlockControllerCustom(properties);
        r.register(framedDrawerController.setRegistryName("framedcompactdrawers", "framed_drawer_controller"));
        framedSlave = new BlockSlaveCustom(properties);
        r.register(framedSlave.setRegistryName("framedcompactdrawers", "framed_slave"));
        framedTrim = new BlockTrimCustom(properties);
        r.register(framedTrim.setRegistryName("framedcompactdrawers", "framed_trim"));
        framedFullOne = new BlockDrawersStandardCustom(1, false, properties);
        r.register(framedFullOne.setRegistryName("framedcompactdrawers", "framed_full_one"));
        framedFullTwo = new BlockDrawersStandardCustom(2, false, properties);
        r.register(framedFullTwo.setRegistryName("framedcompactdrawers", "framed_full_two"));
        framedFullFour = new BlockDrawersStandardCustom(4, false, properties);
        r.register(framedFullFour.setRegistryName("framedcompactdrawers", "framed_full_four"));
        framedHalfOne = new BlockDrawersStandardCustom(1, true, properties);
        r.register(framedHalfOne.setRegistryName("framedcompactdrawers", "framed_half_one"));
        framedHalfTwo = new BlockDrawersStandardCustom(2, true, properties);
        r.register(framedHalfTwo.setRegistryName("framedcompactdrawers", "framed_half_two"));
        framedHalfFour = new BlockDrawersStandardCustom(4, true, properties);
        r.register(framedHalfFour.setRegistryName("framedcompactdrawers", "framed_half_four"));
    }

    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry r = event.getRegistry();
        Item.Properties properties = new Item.Properties().func_200916_a(FramedCompactDrawers.CREATIVE_TAB);
        r.register(new ItemDrawersCustom((Block)framedCompactDrawer, properties).setRegistryName(Objects.requireNonNull(framedCompactDrawer.getRegistryName())));
        r.register(new ItemOtherCustom((Block)framedDrawerController, properties).setRegistryName(Objects.requireNonNull(framedDrawerController.getRegistryName())));
        r.register(new ItemOtherCustom((Block)framedSlave, properties).setRegistryName(Objects.requireNonNull(framedSlave.getRegistryName())));
        r.register(new ItemOtherCustom((Block)framedTrim, properties).setRegistryName(Objects.requireNonNull(framedTrim.getRegistryName())));
        r.register(new ItemDrawersCustom((Block)framedFullOne, properties).setRegistryName(Objects.requireNonNull(framedFullOne.getRegistryName())));
        r.register(new ItemDrawersCustom((Block)framedFullTwo, properties).setRegistryName(Objects.requireNonNull(framedFullTwo.getRegistryName())));
        r.register(new ItemDrawersCustom((Block)framedFullFour, properties).setRegistryName(Objects.requireNonNull(framedFullFour.getRegistryName())));
        r.register(new ItemDrawersCustom((Block)framedHalfOne, properties).setRegistryName(Objects.requireNonNull(framedHalfOne.getRegistryName())));
        r.register(new ItemDrawersCustom((Block)framedHalfTwo, properties).setRegistryName(Objects.requireNonNull(framedHalfTwo.getRegistryName())));
        r.register(new ItemDrawersCustom((Block)framedHalfFour, properties).setRegistryName(Objects.requireNonNull(framedHalfFour.getRegistryName())));
    }

    public static void setRenderLayers() {
        Predicate<RenderType> crf = RenderHelper::canRenderFrameable;
        for (Block block : new Block[]{framedCompactDrawer, framedDrawerController, framedSlave, framedTrim, framedFullOne, framedFullTwo, framedFullFour, framedHalfOne, framedHalfTwo, framedHalfFour}) {
            RenderTypeLookup.setRenderLayer((Block)block, crf);
        }
        framedCompactDrawer.setGeometryData();
        for (BlockDrawersStandardCustom blockDrawersStandardCustom : new BlockDrawersStandardCustom[]{framedFullOne, framedFullTwo, framedFullFour, framedHalfOne, framedHalfTwo, framedHalfFour}) {
            blockDrawersStandardCustom.setGeometryData();
        }
    }

    public static void fill(NonNullList<ItemStack> items) {
        for (Block block : new Block[]{framedCompactDrawer, framedDrawerController, framedSlave, framedTrim, framedFullOne, framedFullTwo, framedFullFour, framedHalfOne, framedHalfTwo, framedHalfFour}) {
            items.add((Object)new ItemStack((IItemProvider)block));
        }
    }

    public static class Tile {
        public static TileEntityType<TileCompDrawersCustom.Slot3> fractionalDrawers3;
        public static TileEntityType<TileControllerCustom> controllerCustom;
        public static TileEntityType<TileSlaveCustom> slaveCustom;
        public static TileEntityType<TileTrimCustom> trimCustom;
        public static TileEntityType<TileDrawersStandardCustom.Slot1> standardDrawers1;
        public static TileEntityType<TileDrawersStandardCustom.Slot2> standardDrawers2;
        public static TileEntityType<TileDrawersStandardCustom.Slot4> standardDrawers4;

        @SubscribeEvent
        public void registerTiles(RegistryEvent.Register<TileEntityType<?>> evt) {
            IForgeRegistry r = evt.getRegistry();
            fractionalDrawers3 = this.registerTile(r, TileCompDrawersCustom.Slot3::new, new Block[]{framedCompactDrawer});
            controllerCustom = this.registerTile(r, TileControllerCustom::new, new Block[]{framedDrawerController});
            slaveCustom = this.registerTile(r, TileSlaveCustom::new, new Block[]{framedSlave});
            trimCustom = this.registerTile(r, TileTrimCustom::new, new Block[]{framedTrim});
            standardDrawers1 = this.registerTile(r, TileDrawersStandardCustom.Slot1::new, new Block[]{framedFullOne, framedHalfOne});
            standardDrawers2 = this.registerTile(r, TileDrawersStandardCustom.Slot2::new, new Block[]{framedFullTwo, framedHalfTwo});
            standardDrawers4 = this.registerTile(r, TileDrawersStandardCustom.Slot4::new, new Block[]{framedFullFour, framedHalfFour});
        }

        private <T extends TileEntity> TileEntityType<T> registerTile(IForgeRegistry<TileEntityType<?>> registry, Supplier<T> supplier, Block ... blocks) {
            TileEntityType type = TileEntityType.Builder.func_223042_a(supplier, (Block[])blocks).func_206865_a(null);
            type.setRegistryName(Objects.requireNonNull(blocks[0].getRegistryName()));
            registry.register((IForgeRegistryEntry)type);
            return type;
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public void registerTERs(ModelBakeEvent evt) {
            for (TileEntityType drawer : ImmutableList.of(fractionalDrawers3, standardDrawers1, standardDrawers2, standardDrawers4)) {
                ClientRegistry.bindTileEntityRenderer((TileEntityType)drawer, TileEntityDrawersRenderer::new);
            }
        }
    }
}

