/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.item.impl;

import cofh.core.util.ProxyUtils;
import cofh.lib.capability.CapabilityArchery;
import cofh.lib.capability.IArcheryAmmoItem;
import cofh.lib.capability.templates.ArcheryAmmoItemWrapper;
import cofh.lib.item.ICoFHItem;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.ArcheryHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CrossbowItemCoFH
extends CrossbowItem
implements ICoFHItem {
    protected int enchantability = 1;
    protected float accuracyModifier = 1.0f;
    protected float damageModifier = 1.0f;
    protected float velocityModifier = 1.0f;

    public CrossbowItemCoFH(Item.Properties builder) {
        super(builder);
        ProxyUtils.registerItemModelProperty((Item)this, new ResourceLocation("pull"), this::getPullModelProperty);
        ProxyUtils.registerItemModelProperty((Item)this, new ResourceLocation("ammo"), this::getAmmoModelProperty);
    }

    public CrossbowItemCoFH(IItemTier tier, Item.Properties builder) {
        this(builder);
        this.setParams(tier);
    }

    public CrossbowItemCoFH(int enchantability, float accuracyModifier, float damageModifier, float velocityModifier, Item.Properties builder) {
        this(builder);
        this.setParams(enchantability, accuracyModifier, damageModifier, velocityModifier);
    }

    public CrossbowItemCoFH setParams(IItemTier tier) {
        this.enchantability = tier.func_200927_e();
        this.damageModifier = tier.func_200929_c() / 4.0f;
        this.velocityModifier = tier.func_200928_b() / 20.0f;
        return this;
    }

    public CrossbowItemCoFH setParams(int enchantability, float accuracyModifier, float damageModifier, float velocityModifier) {
        this.enchantability = enchantability;
        this.accuracyModifier = accuracyModifier;
        this.damageModifier = damageModifier;
        this.velocityModifier = velocityModifier;
        return this;
    }

    public int func_77619_b() {
        return this.enchantability;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.isLoaded(stack)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("info.cofh.crossbow_loaded").func_240702_b_(" ").func_230529_a_(this.getLoadedAmmo(stack).func_151000_E()));
        }
    }

    public float getPullModelProperty(ItemStack stack, World world, LivingEntity entity) {
        if (entity == null || !entity.func_184607_cu().equals(stack)) {
            return 0.0f;
        }
        int baseDuration = this.func_77626_a(stack);
        int duration = baseDuration - entity.func_184605_cv();
        return MathHelper.func_76131_a((float)((float)duration / (float)baseDuration), (float)0.0f, (float)1.0f);
    }

    public float getAmmoModelProperty(ItemStack stack, World world, LivingEntity entity) {
        if (this.getLoadedAmmo(stack).func_190926_b()) {
            return 0.0f;
        }
        if (this.getLoadedAmmo(stack).func_77973_b() instanceof FireworkRocketItem) {
            return 0.5f;
        }
        return 1.0f;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.isLoaded(stack)) {
            this.setLoaded(stack, this.shootLoadedAmmo(world, (LivingEntity)player, hand, stack));
            return ActionResult.func_226249_b_((Object)stack);
        }
        if (!ArcheryHelper.findAmmo(player, stack).func_190926_b() || player.field_71075_bZ.field_75098_d) {
            player.func_184598_c(hand);
            return ActionResult.func_226249_b_((Object)stack);
        }
        return ActionResult.func_226251_d_((Object)stack);
    }

    public int func_77626_a(ItemStack stack) {
        return CrossbowItemCoFH.func_220026_e((ItemStack)stack);
    }

    public void func_219972_a(World world, LivingEntity living, ItemStack stack, int durationRemaining) {
        if (!world.func_201670_d()) {
            int totalDuration = this.func_77626_a(stack);
            int duration = totalDuration - durationRemaining;
            if (duration == totalDuration / 4) {
                world.func_184148_a(null, living.func_226277_ct_(), living.func_226278_cu_(), living.func_226281_cx_(), this.func_220025_a(Utils.getItemEnchantmentLevel(Enchantments.field_222193_H, stack)), SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
            if (duration == totalDuration / 2) {
                world.func_184148_a(null, living.func_226277_ct_(), living.func_226278_cu_(), living.func_226281_cx_(), SoundEvents.field_219611_bC, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity living, int durationRemaining) {
        if (durationRemaining < 0 && !CrossbowItemCoFH.func_220012_d((ItemStack)stack) && this.loadAmmo(living, stack)) {
            CrossbowItemCoFH.func_220011_a((ItemStack)stack, (boolean)true);
            world.func_184148_a(null, living.func_226277_ct_(), living.func_226278_cu_(), living.func_226281_cx_(), SoundEvents.field_219610_bB, living instanceof PlayerEntity ? SoundCategory.PLAYERS : SoundCategory.HOSTILE, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.0f) + 0.2f);
        }
    }

    public boolean loadAmmo(LivingEntity living, ItemStack crossbow) {
        if (living instanceof PlayerEntity) {
            boolean infinite;
            PlayerEntity player = (PlayerEntity)living;
            ItemStack ammo = ArcheryHelper.findAmmo(player, crossbow);
            if (!ammo.func_190926_b() && ammo.func_77973_b() instanceof FireworkRocketItem) {
                crossbow.func_196082_o().func_218657_a("ammo", (INBT)ammo.func_77955_b(new CompoundNBT()));
                if (!player.field_71075_bZ.field_75098_d) {
                    ammo.func_190918_g(1);
                }
                CrossbowItemCoFH.func_220011_a((ItemStack)crossbow, (boolean)true);
                return true;
            }
            IArcheryAmmoItem ammoCap = (IArcheryAmmoItem)ammo.getCapability(CapabilityArchery.AMMO_ITEM_CAPABILITY).orElse((Object)new ArcheryAmmoItemWrapper(ammo));
            boolean bl = infinite = player.field_71075_bZ.field_75098_d || ammoCap.isInfinite(crossbow, player) || ArcheryHelper.isArrow(ammo) && ((ArrowItem)ammo.func_77973_b()).isInfinite(ammo, crossbow, player);
            if (!ammo.func_190926_b() || infinite) {
                if (ammo.func_190926_b()) {
                    ammo = new ItemStack((IItemProvider)Items.field_151032_g);
                }
                crossbow.func_196082_o().func_218657_a("ammo", (INBT)ammo.func_77955_b(new CompoundNBT()));
                CrossbowItemCoFH.func_220011_a((ItemStack)crossbow, (boolean)true);
                if (!infinite) {
                    ammoCap.onArrowLoosed(player);
                    if (ammo.func_190926_b()) {
                        player.field_71071_by.func_184437_d(ammo);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public ItemStack getLoadedAmmo(ItemStack crossbow) {
        CompoundNBT nbt = crossbow.func_77978_p();
        if (nbt != null && nbt.func_74764_b("ammo")) {
            return ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("ammo"));
        }
        return ItemStack.field_190927_a;
    }

    public void setLoaded(ItemStack crossbow, boolean loaded) {
        CrossbowItem.func_220011_a((ItemStack)crossbow, (boolean)loaded);
    }

    public boolean isLoaded(ItemStack crossbow) {
        return CrossbowItem.func_220012_d((ItemStack)crossbow);
    }

    public boolean shootLoadedAmmo(World world, LivingEntity living, Hand hand, ItemStack crossbow) {
        if (living instanceof PlayerEntity) {
            PlayerEntity shooter = (PlayerEntity)living;
            ItemStack ammo = this.getLoadedAmmo(crossbow);
            if (!ammo.func_190926_b()) {
                int multishot = Utils.getItemEnchantmentLevel(Enchantments.field_222192_G, crossbow);
                int damage = 0;
                for (int i = -multishot; i <= multishot; ++i) {
                    AbstractArrowEntity projectile;
                    if (ammo.func_190926_b()) continue;
                    if (ammo.getCapability(CapabilityArchery.AMMO_ITEM_CAPABILITY).isPresent() || ammo.func_77973_b() instanceof ArrowItem) {
                        AbstractArrowEntity arrow = ArcheryHelper.createArrow(world, ammo, shooter);
                        projectile = this.adjustArrow(crossbow, arrow, shooter.field_71075_bZ.field_75098_d || i != 0);
                        ++damage;
                    } else if (ammo.func_77973_b() instanceof FireworkRocketItem) {
                        projectile = new FireworkRocketEntity(world, ammo, (Entity)shooter, shooter.func_226277_ct_(), shooter.func_226280_cw_() - (double)0.15f, shooter.func_226281_cx_(), true);
                        damage += 3;
                    } else {
                        return true;
                    }
                    world.func_217376_c((Entity)this.shootProjectile(shooter, (ProjectileEntity)projectile, this.getBaseSpeed(ammo), 1.0f, (float)i * 10.0f));
                    float pitch = field_77697_d.nextFloat() * 0.32f + 0.865f;
                    world.func_184148_a(null, shooter.func_226277_ct_(), shooter.func_226278_cu_(), shooter.func_226281_cx_(), SoundEvents.field_219616_bH, SoundCategory.PLAYERS, 1.0f, pitch);
                }
                this.onCrossbowShot(shooter, hand, crossbow, damage);
            }
        }
        crossbow.func_196083_e("ammo");
        return false;
    }

    public float getBaseSpeed(ItemStack ammo) {
        return ammo.func_77973_b() instanceof FireworkRocketItem ? 1.6f : 3.15f;
    }

    public AbstractArrowEntity adjustArrow(ItemStack crossbow, AbstractArrowEntity arrow, boolean creativePickup) {
        arrow.func_70243_d(true);
        arrow.func_213869_a(SoundEvents.field_219609_bA);
        arrow.func_213865_o(true);
        int pierce = Utils.getItemEnchantmentLevel(Enchantments.field_222194_I, crossbow);
        if (pierce > 0) {
            arrow.func_213872_b((byte)pierce);
        }
        if (creativePickup) {
            arrow.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
        }
        return arrow;
    }

    public ProjectileEntity shootProjectile(PlayerEntity shooter, ProjectileEntity projectile, float speed, float inaccuracy, float angle) {
        Vector3f vector3f = new Vector3f(shooter.func_70676_i(1.0f));
        vector3f.func_214905_a(new Quaternion(new Vector3f(shooter.func_213286_i(1.0f)), angle, true));
        projectile.func_70186_c((double)vector3f.func_195899_a(), (double)vector3f.func_195900_b(), (double)vector3f.func_195902_c(), speed, inaccuracy);
        return projectile;
    }

    public void onCrossbowShot(PlayerEntity shooter, Hand hand, ItemStack crossbow, int damage) {
        crossbow.func_222118_a(damage, (LivingEntity)shooter, entity -> entity.func_213334_d(hand));
        if (shooter instanceof ServerPlayerEntity) {
            if (!shooter.field_70170_p.func_201670_d()) {
                CriteriaTriggers.field_215099_F.func_215111_a((ServerPlayerEntity)shooter, crossbow);
            }
            shooter.func_71029_a(Stats.field_75929_E.func_199076_b((Object)crossbow.func_77973_b()));
        }
    }
}

