/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.energy;

import cofh.lib.energy.EnergyStorageCoFH;
import java.util.function.IntSupplier;

public class EnergyStorageAdjustable
extends EnergyStorageCoFH {
    protected IntSupplier curReceive = this::getMaxReceive;
    protected IntSupplier curExtract = this::getMaxExtract;

    public EnergyStorageAdjustable(int capacity) {
        this(capacity, capacity, capacity, 0);
    }

    public EnergyStorageAdjustable(int capacity, int maxTransfer) {
        this(capacity, maxTransfer, maxTransfer, 0);
    }

    public EnergyStorageAdjustable(int capacity, int maxReceive, int maxExtract) {
        this(capacity, maxReceive, maxExtract, 0);
    }

    public EnergyStorageAdjustable(int capacity, int maxReceive, int maxExtract, int energy) {
        super(capacity, maxReceive, maxExtract, energy);
    }

    public EnergyStorageAdjustable setTransferLimits(IntSupplier curReceive, IntSupplier curExtract) {
        this.curReceive = curReceive;
        this.curExtract = curExtract;
        return this;
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (maxReceive > this.curReceive.getAsInt()) {
            return super.receiveEnergy(this.curReceive.getAsInt(), simulate);
        }
        return super.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        if (maxExtract > this.curExtract.getAsInt()) {
            return super.extractEnergy(this.curExtract.getAsInt(), simulate);
        }
        return super.extractEnergy(maxExtract, simulate);
    }

    @Override
    public boolean canExtract() {
        return this.curExtract.getAsInt() > 0;
    }

    @Override
    public boolean canReceive() {
        return this.curReceive.getAsInt() > 0;
    }
}

