/*
 * Decompiled with CFR 0.152.
 */
package cofh.core;

import cofh.core.client.gui.HeldItemFilterScreen;
import cofh.core.client.gui.TileItemFilterScreen;
import cofh.core.command.CoFHCommand;
import cofh.core.compat.curios.CuriosProxy;
import cofh.core.compat.quark.QuarkFlags;
import cofh.core.event.ArmorEvents;
import cofh.core.init.CoreBlocks;
import cofh.core.init.CoreConfig;
import cofh.core.init.CoreContainers;
import cofh.core.init.CoreEffects;
import cofh.core.init.CoreEnchantments;
import cofh.core.init.CoreEntities;
import cofh.core.init.CoreFluids;
import cofh.core.init.CoreItems;
import cofh.core.init.CoreKeys;
import cofh.core.init.CoreRecipeSerializers;
import cofh.core.network.packet.client.IndexedChatPacket;
import cofh.core.network.packet.client.PlayerMotionPacket;
import cofh.core.network.packet.client.TileControlPacket;
import cofh.core.network.packet.client.TileGuiPacket;
import cofh.core.network.packet.client.TileRedstonePacket;
import cofh.core.network.packet.client.TileRenderPacket;
import cofh.core.network.packet.client.TileStatePacket;
import cofh.core.network.packet.server.ClaimXPPacket;
import cofh.core.network.packet.server.ContainerPacket;
import cofh.core.network.packet.server.FilterGuiOpenPacket;
import cofh.core.network.packet.server.ItemLeftClickPacket;
import cofh.core.network.packet.server.ItemModeChangePacket;
import cofh.core.network.packet.server.RedstoneControlPacket;
import cofh.core.network.packet.server.SecurityControlPacket;
import cofh.core.network.packet.server.SecurityPacket;
import cofh.core.network.packet.server.SideConfigPacket;
import cofh.core.network.packet.server.StorageClearPacket;
import cofh.core.network.packet.server.TileConfigPacket;
import cofh.core.network.packet.server.TransferControlPacket;
import cofh.core.util.Proxy;
import cofh.core.util.ProxyClient;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.capability.CapabilityArchery;
import cofh.lib.capability.CapabilityAreaEffect;
import cofh.lib.capability.CapabilityEnchantableItem;
import cofh.lib.capability.CapabilityShieldItem;
import cofh.lib.client.renderer.entity.KnifeRenderer;
import cofh.lib.item.impl.SpawnEggItemCoFH;
import cofh.lib.loot.TileNBTSync;
import cofh.lib.network.PacketHandler;
import cofh.lib.util.DeferredRegisterCoFH;
import cofh.lib.util.references.CoreReferences;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.command.CommandSource;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="cofh_core")
public class CoFHCore {
    public static final PacketHandler PACKET_HANDLER = new PacketHandler(new ResourceLocation("cofh_core", "general"));
    public static final Logger LOG = LogManager.getLogger((String)"cofh_core");
    public static final Proxy PROXY = (Proxy)DistExecutor.unsafeRunForDist(() -> ProxyClient::new, () -> Proxy::new);
    public static final DeferredRegisterCoFH<Block> BLOCKS = DeferredRegisterCoFH.create(ForgeRegistries.BLOCKS, "cofh_core");
    public static final DeferredRegisterCoFH<Fluid> FLUIDS = DeferredRegisterCoFH.create(ForgeRegistries.FLUIDS, "cofh_core");
    public static final DeferredRegisterCoFH<Item> ITEMS = DeferredRegisterCoFH.create(ForgeRegistries.ITEMS, "cofh_core");
    public static final DeferredRegisterCoFH<EntityType<?>> ENTITIES = DeferredRegisterCoFH.create(ForgeRegistries.ENTITIES, "cofh_core");
    public static final DeferredRegisterCoFH<ContainerType<?>> CONTAINERS = DeferredRegisterCoFH.create(ForgeRegistries.CONTAINERS, "cofh_core");
    public static final DeferredRegisterCoFH<Effect> EFFECTS = DeferredRegisterCoFH.create(ForgeRegistries.POTIONS, "cofh_core");
    public static final DeferredRegisterCoFH<Enchantment> ENCHANTMENTS = DeferredRegisterCoFH.create(ForgeRegistries.ENCHANTMENTS, "cofh_core");
    public static final DeferredRegisterCoFH<ParticleType<?>> PARTICLES = DeferredRegisterCoFH.create(ForgeRegistries.PARTICLE_TYPES, "cofh_core");
    public static final DeferredRegisterCoFH<IRecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegisterCoFH.create(ForgeRegistries.RECIPE_SERIALIZERS, "cofh_core");
    public static final DeferredRegisterCoFH<TileEntityType<?>> TILE_ENTITIES = DeferredRegisterCoFH.create(ForgeRegistries.TILE_ENTITIES, "cofh_core");
    public static boolean curiosLoaded = false;

    public CoFHCore() {
        curiosLoaded = ModList.get().isLoaded("curios");
        this.registerPackets();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        BLOCKS.register(modEventBus);
        FLUIDS.register(modEventBus);
        ITEMS.register(modEventBus);
        ENTITIES.register(modEventBus);
        CONTAINERS.register(modEventBus);
        EFFECTS.register(modEventBus);
        ENCHANTMENTS.register(modEventBus);
        RECIPE_SERIALIZERS.register(modEventBus);
        TILE_ENTITIES.register(modEventBus);
        CoreConfig.register();
        CoreBlocks.register();
        CoreFluids.register();
        CoreItems.register();
        CoreEntities.register();
        CoreContainers.register();
        CoreEffects.register();
        CoreEnchantments.register();
        CoreRecipeSerializers.register();
        CuriosProxy.register();
    }

    private void registerPackets() {
        PACKET_HANDLER.registerPacket(1, TileControlPacket::new);
        PACKET_HANDLER.registerPacket(2, TileGuiPacket::new);
        PACKET_HANDLER.registerPacket(3, TileRedstonePacket::new);
        PACKET_HANDLER.registerPacket(4, TileStatePacket::new);
        PACKET_HANDLER.registerPacket(5, TileRenderPacket::new);
        PACKET_HANDLER.registerPacket(16, IndexedChatPacket::new);
        PACKET_HANDLER.registerPacket(17, PlayerMotionPacket::new);
        PACKET_HANDLER.registerPacket(20, FilterGuiOpenPacket::new);
        PACKET_HANDLER.registerPacket(24, ContainerPacket::new);
        PACKET_HANDLER.registerPacket(25, SecurityPacket::new);
        PACKET_HANDLER.registerPacket(32, TileConfigPacket::new);
        PACKET_HANDLER.registerPacket(33, SecurityControlPacket::new);
        PACKET_HANDLER.registerPacket(34, RedstoneControlPacket::new);
        PACKET_HANDLER.registerPacket(35, TransferControlPacket::new);
        PACKET_HANDLER.registerPacket(36, SideConfigPacket::new);
        PACKET_HANDLER.registerPacket(37, StorageClearPacket::new);
        PACKET_HANDLER.registerPacket(38, ClaimXPPacket::new);
        PACKET_HANDLER.registerPacket(64, ItemModeChangePacket::new);
        PACKET_HANDLER.registerPacket(65, ItemLeftClickPacket::new);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        CapabilityAreaEffect.register();
        CapabilityArchery.register();
        CapabilityEnchantableItem.register();
        CapabilityShieldItem.register();
        event.enqueueWork(SpawnEggItemCoFH::setup);
        event.enqueueWork(TileNBTSync::setup);
        ArmorEvents.setup();
        QuarkFlags.setup();
        FluidHelper.init();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a(CoreReferences.HELD_ITEM_FILTER_CONTAINER, HeldItemFilterScreen::new);
        ScreenManager.func_216911_a(CoreReferences.TILE_ITEM_FILTER_CONTAINER, TileItemFilterScreen::new);
        CoreKeys.register();
        ProxyClient.registerItemModelProperties();
        this.registerEntityRenderingHandlers();
    }

    private void registerCommands(RegisterCommandsEvent event) {
        CoFHCommand.initialize((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    private void registerEntityRenderingHandlers() {
        RenderingRegistry.registerEntityRenderingHandler(CoreReferences.KNIFE_ENTITY, KnifeRenderer::new);
    }
}

