/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.potion;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.recipehandler.VanillaRecipeTypeRecipeHandler;

public class PotionHelperCommonCapabilities {
    private static List<IRecipeDefinition> VANILLA_RECIPES = null;

    public static List<IRecipeDefinition> getVanillaRecipes() {
        if (VANILLA_RECIPES == null) {
            VANILLA_RECIPES = Lists.newArrayList();
            ArrayList inputItems = Lists.newArrayList((Object[])new ItemStack[]{PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185230_b)});
            ArrayList ingredients = Lists.newArrayList();
            for (PotionBrewing.MixPredicate mixPredicate : PotionBrewing.field_185214_b) {
                ingredients.addAll(VanillaRecipeTypeRecipeHandler.getPrototypesFromIngredient(mixPredicate.field_185199_b));
            }
            for (PotionBrewing.MixPredicate mixPredicate : PotionBrewing.field_185213_a) {
                ingredients.addAll(VanillaRecipeTypeRecipeHandler.getPrototypesFromIngredient(mixPredicate.field_185199_b));
            }
            ArrayList checkInputItems = Lists.newArrayList((Iterable)inputItems);
            while (!checkInputItems.isEmpty()) {
                ArrayList newItems = Lists.newArrayList();
                for (ItemStack inputItem : checkInputItems) {
                    PrototypedIngredient<ItemStack, Integer> item = new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, inputItem, 5);
                    for (IPrototypedIngredient ingredient : ingredients) {
                        ItemStack output = PotionBrewing.func_185212_d((ItemStack)((ItemStack)ingredient.getPrototype()).func_77946_l(), (ItemStack)inputItem.func_77946_l());
                        if (!PotionHelperCommonCapabilities.isPotionOutputValid(inputItem, output)) continue;
                        PotionHelperCommonCapabilities.addRecipeIfNew(ingredient, item, output, newItems);
                    }
                    if (VANILLA_RECIPES.size() <= 7500) continue;
                    throw new RuntimeException("Infinite loop detected! Please report this to the Common Capabilities issue tracker with a list of (potion-changing) mods installed");
                }
                checkInputItems = newItems;
            }
        }
        return VANILLA_RECIPES;
    }

    protected static boolean isPotionOutputValid(ItemStack input, ItemStack output) {
        return !input.func_190926_b() && !output.func_190926_b() && (input.func_77973_b() != output.func_77973_b() || PotionUtils.func_185191_c((ItemStack)output) != Potions.field_185230_b && !Objects.equals(ForgeRegistries.POTION_TYPES.getKey((IForgeRegistryEntry)PotionUtils.func_185191_c((ItemStack)output)), ForgeRegistries.POTION_TYPES.getKey((IForgeRegistryEntry)PotionUtils.func_185191_c((ItemStack)input))));
    }

    protected static void addRecipeIfNew(IPrototypedIngredient<ItemStack, Integer> ingredient, IPrototypedIngredient<ItemStack, Integer> item, ItemStack output, List<ItemStack> newItems) {
        RecipeDefinition recipe = RecipeDefinition.ofIngredients(IngredientComponent.ITEMSTACK, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new IPrototypedIngredient[]{ingredient}), Lists.newArrayList((Object[])new IPrototypedIngredient[]{item}), Lists.newArrayList((Object[])new IPrototypedIngredient[]{item}), Lists.newArrayList((Object[])new IPrototypedIngredient[]{item})}), MixedIngredients.ofInstances(IngredientComponent.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{ItemStack.field_190927_a, output, output, output})));
        if (!VANILLA_RECIPES.contains(recipe)) {
            VANILLA_RECIPES.add(recipe);
            newItems.add(output);
        }
    }
}

