/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tmechworks.client.model;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import slimeknights.tmechworks.api.disguisestate.DisguiseStates;

public class DisguiseBakedModel
extends BakedModelWrapper<IBakedModel> {
    public static final ModelProperty<ItemStack> DISGUISE = new ModelProperty();
    public static final ModelProperty<String> DISGUISE_STATE = new ModelProperty();
    private final Predicate<RenderType> renderTypeLookup;

    public DisguiseBakedModel(IBakedModel originalModel) {
        this(originalModel, RenderType.func_228639_c_());
    }

    public DisguiseBakedModel(IBakedModel originalModel, RenderType defaultRenderType) {
        this(originalModel, (RenderType rt) -> rt == defaultRenderType);
    }

    public DisguiseBakedModel(IBakedModel originalModel, Predicate<RenderType> renderTypeLookup) {
        super(originalModel);
        this.renderTypeLookup = renderTypeLookup;
    }

    @Nonnull
    public List<BakedQuad> getQuads(BlockState state, Direction side, @Nonnull Random rand, IModelData extraData) {
        ItemStack disguise;
        if (extraData.hasProperty(DISGUISE) && (disguise = (ItemStack)extraData.getData(DISGUISE)) != null && disguise.func_77973_b() instanceof BlockItem) {
            BlockItem disguiseItem = (BlockItem)disguise.func_77973_b();
            BlockState disguiseState = disguiseItem.func_179223_d().func_176223_P();
            if (RenderTypeLookup.canRenderInLayer((BlockState)(disguiseState = DisguiseStates.processDisguiseStates(disguiseState, (String)extraData.getData(DISGUISE_STATE), (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H))), (RenderType)MinecraftForgeClient.getRenderLayer())) {
                IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(disguiseState);
                if (model instanceof DisguiseBakedModel) {
                    return ((DisguiseBakedModel)model).getSuperQuads(state, side, rand, extraData);
                }
                return model.getQuads(disguiseState, side, rand, extraData);
            }
            return Collections.emptyList();
        }
        return this.getSuperQuads(state, side, rand, extraData);
    }

    private List<BakedQuad> getSuperQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (this.renderTypeLookup.test(MinecraftForgeClient.getRenderLayer())) {
            return super.getQuads(state, side, rand, extraData);
        }
        return Collections.emptyList();
    }

    @Nonnull
    public IModelData getModelData(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        return super.getModelData(world, pos, state, tileData);
    }
}

