/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tmechworks.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.PacketDistributor;
import slimeknights.tmechworks.api.disguisestate.DisguiseStates;
import slimeknights.tmechworks.client.gui.components.ArrowWidget;
import slimeknights.tmechworks.client.gui.components.DisguiseStateWidget;
import slimeknights.tmechworks.common.MechworksTags;
import slimeknights.tmechworks.common.blocks.tileentity.DrawbridgeTileEntity;
import slimeknights.tmechworks.common.blocks.tileentity.RedstoneMachineTileEntity;
import slimeknights.tmechworks.common.inventory.DrawbridgeContainer;
import slimeknights.tmechworks.common.network.PacketHandler;
import slimeknights.tmechworks.common.network.packet.ServerReopenUiPacket;
import slimeknights.tmechworks.common.network.packet.UpdatePlaceDirectionPacket;
import slimeknights.tmechworks.library.Util;

public class DrawbridgeScreen
extends ContainerScreen<DrawbridgeContainer> {
    public static final ResourceLocation SCREEN_LOCATION = new ResourceLocation("tmechworks", "textures/gui/drawbridge.png");
    public static final ResourceLocation ADVANCED_LOCATION = new ResourceLocation("tmechworks", "textures/gui/drawbridge_advanced.png");
    public DisguiseStateWidget disguiseWidget;
    public final boolean isAdvanced;
    private final int slotCount;

    public DrawbridgeScreen(DrawbridgeContainer container, PlayerInventory inventory, ITextComponent name) {
        super((Container)container, inventory, name);
        this.isAdvanced = ((DrawbridgeTileEntity)container.getTile()).stats.isAdvanced;
        this.slotCount = ((DrawbridgeTileEntity)container.getTile()).slots.func_70302_i_();
    }

    public static DrawbridgeScreen create(DrawbridgeContainer container, PlayerInventory player, ITextComponent title) {
        return new DrawbridgeScreen(container, player, title);
    }

    protected void func_231160_c_() {
        int screenTop;
        int screenLeft;
        int aY;
        int aX;
        super.func_231160_c_();
        if (this.isAdvanced) {
            aX = this.field_147003_i + 192;
            aY = this.field_147009_r + 10;
            screenLeft = -18;
            screenTop = -80;
        } else {
            aX = (this.field_230708_k_ - this.field_146999_f) / 2 + 110;
            aY = (this.field_230709_l_ - this.field_147000_g) / 2 + 20;
            screenLeft = 0;
            screenTop = 0;
        }
        this.field_238742_p_ = screenLeft + 8;
        this.field_238743_q_ = screenTop + 6;
        ArrowWidget arrow = new ArrowWidget(aX, aY, this.field_230708_k_, this.field_230709_l_, true, this::arrowClicked);
        this.updateSelection(arrow);
        this.func_230480_a_(arrow);
        this.disguiseWidget = new DisguiseStateWidget(this.field_147003_i + 198, this.field_147009_r + 133, (RedstoneMachineTileEntity)((DrawbridgeContainer)this.field_147002_h).getTile());
        this.func_230480_a_(this.disguiseWidget);
    }

    public void func_231023_e_() {
        ItemStack disguise;
        super.func_231023_e_();
        DrawbridgeTileEntity te = (DrawbridgeTileEntity)((DrawbridgeContainer)this.field_147002_h).getTile();
        if (this.isAdvanced != te.stats.isAdvanced || this.slotCount != te.slots.func_70302_i_()) {
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new ServerReopenUiPacket(((DrawbridgeTileEntity)((DrawbridgeContainer)this.field_147002_h).getTile()).func_174877_v()));
        }
        if ((disguise = te.getDisguiseBlock()).func_77973_b() instanceof BlockItem) {
            BlockState disguiseState = ((BlockItem)disguise.func_77973_b()).func_179223_d().func_176223_P();
            this.disguiseWidget.setState(DisguiseStates.getForState(disguiseState), te.getDisguiseState());
        } else {
            this.disguiseWidget.setState(null, null);
        }
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(stack, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(SCREEN_LOCATION);
        this.func_238474_b_(stack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_238474_b_(stack, this.field_147003_i - 44, this.field_147009_r + this.field_147000_g - 65, 0, 182, 47, 60);
        this.func_238474_b_(stack, this.field_147003_i + this.field_146999_f - 3, this.field_147009_r + this.field_147000_g - 37, 52, 182, 29, 32);
        if (this.disguiseWidget.getColumnCount() > 0) {
            DrawbridgeScreen.blit(stack, this.field_147003_i + this.field_146999_f + 22, this.field_147009_r + this.field_147000_g - 37, this.disguiseWidget.getColumnCount() * 8 + 2, 32, 75, 76, 182, 214);
            DrawbridgeScreen.blit(stack, this.field_147003_i + this.field_146999_f + 22 + this.disguiseWidget.getColumnCount() * 8 + 2, this.field_147009_r + this.field_147000_g - 37, 3, 32, 78, 81, 183, 214);
        }
        if (!this.isAdvanced) {
            this.drawSlicedBox(stack, this.field_147003_i + 75, this.field_147009_r + 31, 26, 26, 17, 166);
        } else {
            this.field_230706_i_.func_110434_K().func_110577_a(ADVANCED_LOCATION);
            this.func_238474_b_(stack, this.field_147003_i - 18, this.field_147009_r - 80, 0, 0, 213, 148);
            this.func_238474_b_(stack, this.field_147003_i + 191, this.field_147009_r + 4, 0, 196, 63, 60);
            this.drawAdvancedSlots(stack);
        }
    }

    private void drawAdvancedSlots(MatrixStack stack) {
        for (Slot s : ((DrawbridgeContainer)this.field_147002_h).mainSlots) {
            this.func_238474_b_(stack, this.field_147003_i + s.field_75223_e - 1, this.field_147009_r + s.field_75221_f - 1, 0, 166, 18, 18);
        }
    }

    protected void func_230459_a_(MatrixStack stack, int mouseX, int mouseY) {
        if (this.field_147006_u == null) {
            return;
        }
        if (!this.isAdvanced || this.field_147006_u.func_75216_d()) {
            super.func_230459_a_(stack, mouseX, mouseY);
        } else if (this.field_147006_u.field_75224_c == ((DrawbridgeTileEntity)((DrawbridgeContainer)this.func_212873_a_()).getTile()).slots) {
            this.func_238652_a_(stack, (ITextComponent)new TranslationTextComponent(Util.prefix("gui.blocknum"), new Object[]{this.field_147006_u.getSlotIndex() + 1}).func_230530_a_(Style.field_240709_b_.func_240721_b_(TextFormatting.GRAY)), mouseX, mouseY);
        }
    }

    public List<ITextComponent> func_231151_a_(ItemStack stack) {
        List list = super.func_231151_a_(stack);
        if (this.isAdvanced && this.field_147006_u.field_75224_c == ((DrawbridgeTileEntity)((DrawbridgeContainer)this.func_212873_a_()).getTile()).slots) {
            list.add(StringTextComponent.field_240750_d_);
            list.add(new TranslationTextComponent(Util.prefix("gui.blocknum"), new Object[]{this.field_147006_u.getSlotIndex() + 1}).func_240699_a_(TextFormatting.GRAY));
        }
        if (MechworksTags.Blocks.DRAWBRIDGE_BLACKLIST.func_230235_a_((Object)Block.func_149634_a((Item)stack.func_77973_b()))) {
            list.add(StringTextComponent.field_240750_d_);
            list.add(new TranslationTextComponent(Util.prefix("gui.blacklisted")));
        }
        return list;
    }

    protected void func_230451_b_(MatrixStack stack, int mouseX, int mouseY) {
        super.func_230451_b_(stack, mouseX, mouseY);
        float scale = 0.75f;
        float invScale = 1.0f / scale;
        RenderSystem.scalef((float)scale, (float)scale, (float)scale);
        String upgrades = I18n.func_135052_a((String)Util.prefix("gui.upgrades"), (Object[])new Object[0]);
        this.field_230712_o_.func_238421_b_(stack, upgrades, 23.5f - (float)this.field_230712_o_.func_78256_a(upgrades) / 2.0f - 50.0f, (float)(this.field_146999_f - 69) * invScale, 0x404040);
        RenderSystem.scalef((float)invScale, (float)invScale, (float)invScale);
    }

    private void arrowClicked(ArrowWidget widget, ArrowWidget.Arrow arrow) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new UpdatePlaceDirectionPacket(((DrawbridgeTileEntity)((DrawbridgeContainer)this.field_147002_h).getTile()).func_174877_v(), arrow.ordinal()));
        ((DrawbridgeTileEntity)((DrawbridgeContainer)this.field_147002_h).getTile()).setPlaceDirection(arrow.ordinal());
        this.updateSelection(widget);
    }

    private void updateSelection(ArrowWidget arrow) {
        for (ArrowWidget.Arrow a : ArrowWidget.Arrow.values()) {
            if (arrow.getState(a) != ArrowWidget.ArrowState.SELECTED) continue;
            arrow.setState(a, ArrowWidget.ArrowState.ENABLED);
        }
        arrow.setState(ArrowWidget.Arrow.values()[((DrawbridgeTileEntity)((DrawbridgeContainer)this.field_147002_h).getTile()).getRawPlaceDirection().ordinal()], ArrowWidget.ArrowState.SELECTED);
        arrow.setState(ArrowWidget.Arrow.values()[Direction.values().length + ((DrawbridgeTileEntity)((DrawbridgeContainer)this.field_147002_h).getTile()).getPlaceAngle().ordinal()], ArrowWidget.ArrowState.SELECTED);
    }

    private void drawSlicedBox(MatrixStack stack, int x, int y, int width, int height, int u, int v) {
        this.func_238474_b_(stack, x, y, u, v, 4, 4);
        this.func_238474_b_(stack, x + width - 4, y, u + 12, v, 4, 4);
        this.func_238474_b_(stack, x, y + height - 4, u, v + 12, 4, 4);
        this.func_238474_b_(stack, x + width - 4, y + height - 4, u + 12, v + 12, 4, 4);
        DrawbridgeScreen.blit(stack, x + 4, y, width - 8, 4, u + 6, u + 10, v, v + 4);
        DrawbridgeScreen.blit(stack, x + 4, y + height - 4, width - 8, 4, u + 6, u + 10, v + 12, v + 16);
        DrawbridgeScreen.blit(stack, x, y + 4, 4, height - 8, u, u + 4, v + 6, v + 10);
        DrawbridgeScreen.blit(stack, x + width - 4, y + 4, 4, height - 8, u + 12, u + 16, v + 6, v + 10);
        DrawbridgeScreen.blit(stack, x + 4, y + 4, width - 8, height - 8, u + 6, u + 10, v + 6, v + 10);
    }

    public static void blit(MatrixStack stack, int x, int y, int w, int h, int minU, int maxU, int minV, int maxV) {
        DrawbridgeScreen.blit(stack, x, y, w, h, minU, maxU, minV, maxV, 256.0f, 256.0f);
    }

    public static void blit(MatrixStack stack, int x, int y, int w, int h, int minU, int maxU, int minV, int maxV, float tw, float th) {
        DrawbridgeScreen.innerBlit(stack.func_227866_c_().func_227870_a_(), x, x + w, y, y + h, 0, (float)minU / tw, (float)maxU / tw, (float)minV / th, (float)maxV / th);
    }

    private static void innerBlit(Matrix4f matrix, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV) {
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix, (float)x1, (float)y2, (float)blitOffset).func_225583_a_(minU, maxV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x2, (float)y2, (float)blitOffset).func_225583_a_(maxU, maxV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x2, (float)y1, (float)blitOffset).func_225583_a_(maxU, minV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x1, (float)y1, (float)blitOffset).func_225583_a_(minU, minV).func_181675_d();
        bufferbuilder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }
}

