/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.MaterialList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.client.util.ColorUtils;
import net.silentchaos512.gear.client.util.TextListBuilder;
import net.silentchaos512.gear.gear.material.LazyMaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.SynergyUtils;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.util.NameUtils;
import net.silentchaos512.utils.Color;

public class CompoundPartItem
extends Item {
    private static final String NBT_CRAFTED_COUNT = "CraftedCount";
    private static final String NBT_MATERIALS = "Materials";
    private final PartType partType;

    public CompoundPartItem(PartType partType, Item.Properties properties) {
        super(properties);
        this.partType = partType;
    }

    public PartType getPartType() {
        return this.partType;
    }

    public GearType getGearType() {
        return GearType.PART;
    }

    public int getCraftedCount(ItemStack stack) {
        if (stack.func_196082_o().func_74764_b(NBT_CRAFTED_COUNT)) {
            return stack.func_196082_o().func_74762_e(NBT_CRAFTED_COUNT);
        }
        if (this == ModItems.BINDING.get()) {
            return CompoundPartItem.getMaterials(stack).size();
        }
        if (this == ModItems.BOWSTRING.get()) {
            return 1;
        }
        if (this == ModItems.COATING.get()) {
            return CompoundPartItem.getMaterials(stack).size();
        }
        if (this == ModItems.FLETCHING.get()) {
            return CompoundPartItem.getMaterials(stack).size();
        }
        if (this == ModItems.GRIP.get()) {
            return CompoundPartItem.getMaterials(stack).size();
        }
        if (this == ModItems.LONG_ROD.get()) {
            return 2;
        }
        if (this == ModItems.ROD.get()) {
            return 4;
        }
        if (this == ModItems.TIP.get()) {
            return CompoundPartItem.getMaterials(stack).size();
        }
        SilentGear.LOGGER.error("Unknown part with no crafted count: {}", (Object)stack);
        return 1;
    }

    public ItemStack create(IMaterialInstance material) {
        return this.create(material, -1);
    }

    public ItemStack create(Collection<? extends IMaterialInstance> materials) {
        return this.create(MaterialList.of(materials), -1);
    }

    public ItemStack create(IMaterialInstance material, int craftedCount) {
        return this.create(MaterialList.of(material), craftedCount);
    }

    public ItemStack create(MaterialList materials) {
        return this.create(materials, -1);
    }

    public ItemStack create(MaterialList materials, int craftedCount) {
        ListNBT materialListNbt = materials.serializeNbt();
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a(NBT_MATERIALS, (INBT)materialListNbt);
        if (craftedCount > 0) {
            tag.func_74768_a(NBT_CRAFTED_COUNT, craftedCount);
        }
        ItemStack result = new ItemStack((IItemProvider)this, craftedCount > 0 ? craftedCount : 1);
        result.func_77982_d(tag);
        return result;
    }

    public static MaterialList getMaterials(ItemStack stack) {
        ListNBT materialListNbt = stack.func_196082_o().func_150295_c(NBT_MATERIALS, 10);
        return MaterialList.deserializeNbt(materialListNbt);
    }

    @Nullable
    public static MaterialInstance getPrimaryMaterial(ItemStack stack) {
        INBT nbt;
        ListNBT listNbt = stack.func_196082_o().func_150295_c(NBT_MATERIALS, 10);
        if (!listNbt.isEmpty() && (nbt = listNbt.get(0)) instanceof CompoundNBT) {
            return MaterialInstance.read((CompoundNBT)nbt);
        }
        return null;
    }

    public static String getModelKey(ItemStack stack) {
        StringBuilder s = new StringBuilder(SilentGear.shortenId(NameUtils.fromItem((ItemStack)stack)) + "#");
        if (!stack.func_77942_o()) {
            return s.append(Const.Materials.EXAMPLE.getId()).toString();
        }
        for (IMaterialInstance material : CompoundPartItem.getMaterials(stack)) {
            s.append(SilentGear.shortenId(material.getId()));
        }
        return s.toString();
    }

    public int getColor(ItemStack stack, int layer) {
        return ColorUtils.getBlendedColor(this, (Collection<? extends IMaterialInstance>)CompoundPartItem.getMaterials(stack), layer);
    }

    public int getColorWeight(int index, int totalCount) {
        return totalCount - index;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        PartData part = PartData.from(stack);
        MaterialInstance material = CompoundPartItem.getPrimaryMaterial(stack);
        if (part != null && material != null) {
            TranslationTextComponent nameText = new TranslationTextComponent(this.func_77658_a() + ".nameProper", new Object[]{material.getDisplayName(this.partType, ItemStack.field_190927_a)});
            int nameColor = Color.blend((int)part.getColor(ItemStack.field_190927_a), (int)0xFFFFFF, (float)0.25f) & 0xFFFFFF;
            return TextUtil.withColor((IFormattableTextComponent)nameText, nameColor);
        }
        return super.func_200295_i(stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        PartData part = PartData.from(stack);
        if (part != null) {
            float synergy = SynergyUtils.getSynergy(this.partType, CompoundPartItem.getMaterials(stack), part.getTraits());
            tooltip.add(SynergyUtils.getDisplayText(synergy));
            TextListBuilder matsBuilder = new TextListBuilder();
            CompoundPartItem.getMaterials(stack).forEach(material -> {
                int nameColor = material.getNameColor(part.getType(), this.getGearType());
                matsBuilder.add((ITextComponent)TextUtil.withColor(material.getDisplayNameWithGrade(part.getType(), ItemStack.field_190927_a), nameColor));
            });
            tooltip.addAll(matsBuilder.build());
        }
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(group) || this == ModItems.ARMOR_BODY.get() || this == ModItems.SHIELD_PLATE.get()) {
            return;
        }
        items.add((Object)this.create(LazyMaterialInstance.of(Const.Materials.EXAMPLE)));
    }
}

