/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.gear.trait.SimpleTrait;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.util.NameUtils;

public class TargetEffectTrait
extends SimpleTrait {
    public static final ITraitSerializer<TargetEffectTrait> SERIALIZER = new SimpleTrait.Serializer<TargetEffectTrait>(SilentGear.getId("target_effect"), TargetEffectTrait::new, TargetEffectTrait::deserialize, TargetEffectTrait::read, TargetEffectTrait::write);
    private final Map<String, EffectMap> effects = new LinkedHashMap<String, EffectMap>();

    public TargetEffectTrait(ResourceLocation id) {
        super(id, SERIALIZER);
    }

    @Override
    public float onAttackEntity(TraitActionContext context, LivingEntity target, float baseValue) {
        GearType type = GearHelper.getType(context.getGear());
        for (String typeStr : this.effects.keySet()) {
            if (!type.matches(typeStr)) continue;
            this.effects.get(typeStr).applyTo(target, context.getTraitLevel());
        }
        return super.onAttackEntity(context, target, baseValue);
    }

    private static void deserialize(TargetEffectTrait trait, JsonObject json) {
        if (!json.has("effects")) {
            throw new JsonParseException("Target effect trait '" + trait.getId() + "' is missing 'effects' object");
        }
        JsonObject jsonEffects = json.getAsJsonObject("effects");
        for (Map.Entry entry : jsonEffects.entrySet()) {
            String gearTypeKey = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if (!element.isJsonObject()) {
                throw new JsonParseException("Expected object, found " + element.getClass().getSimpleName());
            }
            EffectMap list = EffectMap.deserialize(element.getAsJsonObject());
            trait.effects.put(gearTypeKey, list);
        }
    }

    private static void read(TargetEffectTrait trait, PacketBuffer buffer) {
        trait.effects.clear();
        int mapSize = buffer.readByte();
        for (int i = 0; i < mapSize; ++i) {
            String key = buffer.func_218666_n();
            EffectMap list = EffectMap.read(buffer);
            trait.effects.put(key, list);
        }
    }

    private static void write(TargetEffectTrait trait, PacketBuffer buffer) {
        buffer.writeByte(trait.effects.size());
        for (Map.Entry<String, EffectMap> entry : trait.effects.entrySet()) {
            buffer.func_180714_a(entry.getKey());
            entry.getValue().write(buffer);
        }
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        Collection<String> ret = super.getExtraWikiLines();
        this.effects.forEach((type, map) -> {
            ret.add("  - " + type);
            ret.addAll(map.getWikiLines());
        });
        return ret;
    }

    public static class EffectMap {
        private final Map<Integer, List<EffectInstance>> effects = new LinkedHashMap<Integer, List<EffectInstance>>();

        public EffectMap(Map<Integer, List<EffectInstance>> effects) {
            this.effects.putAll(effects);
        }

        public void applyTo(LivingEntity target, int traitLevel) {
            if (this.effects.containsKey(traitLevel)) {
                for (EffectInstance effect : this.effects.get(traitLevel)) {
                    EffectInstance copy = new EffectInstance(effect);
                    target.func_195064_c(copy);
                }
            }
        }

        public JsonObject serialize() {
            JsonObject json = new JsonObject();
            for (Map.Entry<Integer, List<EffectInstance>> entry : this.effects.entrySet()) {
                int level = entry.getKey();
                List<EffectInstance> list = entry.getValue();
                JsonArray array = new JsonArray();
                for (EffectInstance inst : list) {
                    JsonObject obj = new JsonObject();
                    obj.addProperty("effect", NameUtils.from((IForgeRegistryEntry)inst.func_188419_a()).toString());
                    obj.addProperty("amplifier", (Number)inst.func_76458_c());
                    obj.addProperty("duration", (Number)Float.valueOf((float)inst.func_76459_b() / 20.0f));
                    array.add((JsonElement)obj);
                }
                json.add(String.valueOf(level), (JsonElement)array);
            }
            return json;
        }

        static EffectMap deserialize(JsonObject json) {
            LinkedHashMap<Integer, List<EffectInstance>> map = new LinkedHashMap<Integer, List<EffectInstance>>();
            for (Map.Entry entry : json.entrySet()) {
                int level = Integer.parseInt((String)entry.getKey());
                JsonElement element = (JsonElement)entry.getValue();
                if (element.isJsonArray()) {
                    ArrayList<EffectInstance> list = new ArrayList<EffectInstance>();
                    for (JsonElement effectJson : element.getAsJsonArray()) {
                        list.add(EffectMap.deserialize(effectJson));
                    }
                    map.put(level, list);
                    continue;
                }
                if (element.isJsonObject()) {
                    map.put(level, Collections.singletonList(EffectMap.deserialize(element)));
                    continue;
                }
                throw new JsonParseException("Expected effects for level element to be either array or object");
            }
            return new EffectMap(map);
        }

        private static EffectInstance deserialize(JsonElement jsonElement) {
            if (!jsonElement.isJsonObject()) {
                throw new JsonParseException("Expected effect instance element to be an object");
            }
            JsonObject json = jsonElement.getAsJsonObject();
            ResourceLocation effectId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"effect"));
            Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(effectId);
            if (effect == null) {
                throw new JsonParseException("Unknown effect ID: " + effectId);
            }
            int level = JSONUtils.func_151208_a((JsonObject)json, (String)"amplifier", (int)0);
            float duration = JSONUtils.func_151221_a((JsonObject)json, (String)"duration", (float)5.0f);
            return new EffectInstance(effect, (int)duration * 20, level);
        }

        public static EffectMap read(PacketBuffer buffer) {
            int mapSize = buffer.readByte();
            LinkedHashMap<Integer, List<EffectInstance>> result = new LinkedHashMap<Integer, List<EffectInstance>>();
            for (int i = 0; i < mapSize; ++i) {
                byte level = buffer.readByte();
                int listSize = buffer.readByte();
                ArrayList<EffectInstance> list = new ArrayList<EffectInstance>(listSize);
                for (int j = 0; j < listSize; ++j) {
                    ResourceLocation effectId = buffer.func_192575_l();
                    Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(effectId);
                    if (effect == null) {
                        throw new JsonParseException("Unknown effect ID: " + effectId);
                    }
                    byte amplifier = buffer.readByte();
                    int duration = buffer.func_150792_a();
                    list.add(new EffectInstance(effect, duration, (int)amplifier));
                }
                result.put(Integer.valueOf(level), list);
            }
            return new EffectMap(result);
        }

        public void write(PacketBuffer buffer) {
            buffer.writeByte(this.effects.size());
            for (Map.Entry<Integer, List<EffectInstance>> entry : this.effects.entrySet()) {
                buffer.writeByte(entry.getKey().intValue());
                buffer.writeByte(entry.getValue().size());
                for (EffectInstance effect : entry.getValue()) {
                    buffer.func_192572_a(NameUtils.from((IForgeRegistryEntry)effect.func_188419_a()));
                    buffer.writeByte(effect.func_76458_c());
                    buffer.func_150787_b(effect.func_76459_b());
                }
            }
        }

        public Collection<String> getWikiLines() {
            ArrayList<String> ret = new ArrayList<String>();
            this.effects.forEach((level, list) -> {
                ret.add("    - Level " + level + ":");
                list.forEach(effect -> ret.add("      - " + effect));
            });
            return ret;
        }
    }
}

