/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.gear.trait.SimpleTrait;
import net.silentchaos512.gear.util.GearHelper;

public final class NBTTrait
extends SimpleTrait {
    private static final ResourceLocation SERIALIZER_ID = SilentGear.getId("nbt_trait");
    static final ITraitSerializer<NBTTrait> SERIALIZER = new SimpleTrait.Serializer<NBTTrait>(SERIALIZER_ID, NBTTrait::new, NBTTrait::readJson, NBTTrait::readBuffer, NBTTrait::writeBuffer);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<String, List<DataEntry>> data = new HashMap<String, List<DataEntry>>();

    private NBTTrait(ResourceLocation id) {
        super(id, SERIALIZER);
    }

    @Override
    public void onGearCrafted(TraitActionContext context) {
        ItemStack gear = context.getGear();
        GearType gearType = GearHelper.getType(gear);
        int traitLevel = context.getTraitLevel();
        this.data.forEach((type, list) -> {
            if (gearType.matches((String)type) || "all".equals(type)) {
                list.stream().filter(e -> ((DataEntry)e).level == traitLevel).forEach(e -> gear.func_196082_o().func_197643_a(((DataEntry)e).data));
            }
        });
    }

    private static void readJson(NBTTrait trait, JsonObject json) {
        if (!json.has("nbt")) {
            throw new JsonParseException("NBT trait '" + trait.getId() + "' is missing 'nbt' object");
        }
        JsonObject jsonNbt = json.getAsJsonObject("nbt");
        for (Map.Entry entry : jsonNbt.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if (!element.isJsonArray()) {
                throw new JsonParseException("Expected array, found " + element.getClass().getSimpleName());
            }
            JsonArray array = element.getAsJsonArray();
            ArrayList<DataEntry> list = new ArrayList<DataEntry>();
            for (JsonElement elem : array) {
                if (!elem.isJsonObject()) {
                    throw new JsonParseException("Expected object, found " + elem.getClass().getSimpleName());
                }
                list.add(DataEntry.from(elem.getAsJsonObject()));
            }
            if (list.isEmpty()) continue;
            trait.data.put(key, list);
        }
    }

    private static void readBuffer(NBTTrait trait, PacketBuffer buffer) {
        trait.data.clear();
        int gearTypeCount = buffer.readByte();
        for (int typeIndex = 0; typeIndex < gearTypeCount; ++typeIndex) {
            ArrayList<DataEntry> list = new ArrayList<DataEntry>();
            String gearType = buffer.func_218666_n();
            int dataCount = buffer.readByte();
            for (int dataIndex = 0; dataIndex < dataCount; ++dataIndex) {
                list.add(DataEntry.read(buffer));
            }
            trait.data.put(gearType, list);
        }
    }

    private static void writeBuffer(NBTTrait trait, PacketBuffer buffer) {
        buffer.writeByte(trait.data.size());
        trait.data.forEach((type, list) -> {
            buffer.func_180714_a(type);
            buffer.writeByte(list.size());
            list.forEach(e -> e.write(buffer));
        });
    }

    public static class DataEntry {
        private int level;
        private CompoundNBT data = new CompoundNBT();

        static DataEntry from(JsonObject json) {
            DataEntry ret = new DataEntry();
            ret.level = JSONUtils.func_151208_a((JsonObject)json, (String)"level", (int)1);
            try {
                JsonElement element = json.get("data");
                ret.data = element.isJsonObject() ? JsonToNBT.func_180713_a((String)GSON.toJson(element)) : JsonToNBT.func_180713_a((String)JSONUtils.func_151200_h((JsonObject)json, (String)"data"));
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
            return ret;
        }

        static DataEntry read(PacketBuffer buffer) {
            DataEntry ret = new DataEntry();
            ret.level = buffer.readByte();
            ret.data = buffer.func_150793_b();
            return ret;
        }

        void write(PacketBuffer buffer) {
            buffer.writeByte(this.level);
            buffer.func_150786_a(this.data);
        }
    }
}

