/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.enchantment.IStatModifierEnchantment;
import net.silentchaos512.gear.api.event.GetMaterialStatsEvent;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialCategory;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.MaterialLayer;
import net.silentchaos512.gear.api.material.MaterialList;
import net.silentchaos512.gear.api.part.MaterialGrade;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ChargedProperties;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.api.util.StatGearKey;
import net.silentchaos512.gear.client.material.MaterialDisplayManager;
import net.silentchaos512.gear.gear.material.LazyMaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.gear.part.RepairContext;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.DataResource;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.util.InventoryUtils;

public final class MaterialInstance
implements IMaterialInstance {
    private static final Map<ResourceLocation, MaterialInstance> QUICK_CACHE = new HashMap<ResourceLocation, MaterialInstance>();
    private final IMaterial material;
    private final MaterialGrade grade;
    private final ItemStack item;

    private MaterialInstance(IMaterial material) {
        this(material, MaterialGrade.NONE, material.getDisplayItem(PartType.MAIN, 0));
    }

    private MaterialInstance(IMaterial material, MaterialGrade grade) {
        this(material, grade, material.getDisplayItem(PartType.MAIN, 0));
    }

    private MaterialInstance(IMaterial material, ItemStack craftingItem) {
        this(material, MaterialGrade.NONE, craftingItem);
    }

    private MaterialInstance(IMaterial material, MaterialGrade grade, ItemStack craftingItem) {
        this.material = material;
        this.grade = grade;
        this.item = craftingItem.func_77946_l();
        this.item.func_190920_e(1);
    }

    public static MaterialInstance of(IMaterial material) {
        return QUICK_CACHE.computeIfAbsent(material.getId(), id -> new MaterialInstance(material));
    }

    public static MaterialInstance of(IMaterial material, MaterialGrade grade) {
        return new MaterialInstance(material, grade);
    }

    public static MaterialInstance of(IMaterial material, ItemStack craftingItem) {
        return new MaterialInstance(material, MaterialGrade.fromStack(craftingItem), craftingItem);
    }

    public static MaterialInstance of(IMaterial material, MaterialGrade grade, ItemStack craftingItem) {
        return new MaterialInstance(material, grade, craftingItem);
    }

    public static IMaterialInstance of(DataResource<IMaterial> material, ItemStack craftingItem) {
        if (material.isPresent()) {
            return MaterialInstance.of(material.get(), craftingItem);
        }
        return LazyMaterialInstance.of(material, MaterialGrade.fromStack(craftingItem));
    }

    @Nullable
    public static MaterialInstance from(ItemStack stack) {
        IMaterial material = MaterialManager.from(stack);
        if (material != null) {
            return MaterialInstance.of(material, stack);
        }
        return null;
    }

    @Override
    public ResourceLocation getId() {
        return this.material.getId();
    }

    @Override
    @Nonnull
    public IMaterial get() {
        return this.material;
    }

    @Override
    public MaterialGrade getGrade() {
        return this.grade;
    }

    @Override
    public MaterialList getMaterials() {
        return this.material.getMaterials(this);
    }

    @Override
    public ItemStack getItem() {
        return this.item;
    }

    @Override
    public Collection<IMaterialCategory> getCategories() {
        return this.material.getCategories(this);
    }

    @Override
    public Ingredient getIngredient() {
        return this.material.getIngredient();
    }

    @Override
    public int getTier(PartType partType) {
        return this.material.getTier(this, partType);
    }

    @Override
    public Collection<StatInstance> getStatModifiers(PartType partType, StatGearKey key, ItemStack gear) {
        List<StatInstance> mods = new ArrayList<StatInstance>(this.material.getStatModifiers(this, partType, key, gear));
        ItemStat stat = ItemStats.get(key.getStat());
        if (stat == null) {
            SilentGear.LOGGER.warn("Unknown item stat: {}", (Object)key.getStat().getStatId());
            SilentGear.LOGGER.catching((Throwable)new NullPointerException());
            return mods;
        }
        if (stat.isAffectedByGrades() && this.grade != MaterialGrade.NONE) {
            float bonus = (float)this.grade.bonusPercent / 100.0f;
            mods = mods.stream().map(m -> {
                float value = m.getValue();
                return m.copySetValue(value + Math.abs(value) * bonus);
            }).collect(Collectors.toList());
        }
        this.getEnchantmentModifiedStats(mods, key);
        GetMaterialStatsEvent event = new GetMaterialStatsEvent(this, stat, partType, mods);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getModifiers();
    }

    private void getEnchantmentModifiedStats(List<StatInstance> mods, StatGearKey key) {
        if (key.getStat() == ItemStats.CHARGEABILITY || key.getStat() == Const.SGEMS_CHARGEABILITY) {
            return;
        }
        for (Map.Entry entry : EnchantmentHelper.func_82781_a((ItemStack)this.item).entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            Integer level = (Integer)entry.getValue();
            if (!(enchantment instanceof IStatModifierEnchantment)) continue;
            IStatModifierEnchantment statModifierEnchantment = (IStatModifierEnchantment)enchantment;
            ChargedProperties charge = new ChargedProperties(level, this.getChargeability());
            for (int i = 0; i < mods.size(); ++i) {
                StatInstance mod = mods.get(i);
                StatInstance newMod = statModifierEnchantment.modifyStat(key, mod, charge);
                if (newMod == null) continue;
                mods.remove(i);
                mods.add(i, newMod);
            }
        }
    }

    private float getChargeability() {
        return Math.max(this.getStat(PartType.MAIN, ItemStats.CHARGEABILITY), this.getStat(PartType.MAIN, Const.SGEMS_CHARGEABILITY));
    }

    @Override
    public float getStat(PartType partType, StatGearKey key, ItemStack gear) {
        ItemStat stat = ItemStats.get(key.getStat());
        if (stat == null) {
            return key.getStat().getDefaultValue();
        }
        return stat.compute(stat.getDefaultValue(), this.getStatModifiers(partType, key));
    }

    @Override
    public Collection<TraitInstance> getTraits(PartGearKey partKey, ItemStack gear) {
        return this.material.getTraits(this, partKey, gear);
    }

    public boolean canRepair(ItemStack gear) {
        return this.material.allowedInPart(this, PartType.MAIN) && GearData.getTier(gear) <= this.getTier(PartType.MAIN);
    }

    public int getRepairValue(ItemStack gear) {
        return this.getRepairValue(gear, RepairContext.Type.QUICK);
    }

    public int getRepairValue(ItemStack gear, RepairContext.Type type) {
        if (this.canRepair(gear)) {
            float durability = this.getStat(PartType.MAIN, GearHelper.getDurabilityStat(gear));
            float repairValueMulti = this.getStat(PartType.MAIN, ItemStats.REPAIR_VALUE);
            float itemRepairModifier = GearHelper.getRepairModifier(gear);
            float typeBonus = 1.0f + type.getBonusEfficiency();
            return Math.round(durability * repairValueMulti * itemRepairModifier * typeBonus) + 1;
        }
        return 0;
    }

    @Nullable
    public static MaterialInstance read(CompoundNBT nbt) {
        ResourceLocation id = ResourceLocation.func_208304_a((String)nbt.func_74779_i("ID"));
        IMaterial material = MaterialManager.get(id);
        if (material == null) {
            return null;
        }
        ItemStack stack = MaterialInstance.readOrGetDefaultItem(material, nbt);
        return MaterialInstance.of(material, stack);
    }

    private static ItemStack readOrGetDefaultItem(IMaterial material, CompoundNBT nbt) {
        ItemStack[] array;
        ItemStack stack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Item"));
        if (stack.func_190926_b() && (array = material.getIngredient().func_193365_a()).length > 0) {
            return array[0].func_77946_l();
        }
        return stack;
    }

    @Override
    public CompoundNBT write(CompoundNBT nbt) {
        nbt.func_74778_a("ID", this.material.getId().toString());
        nbt.func_218657_a("Item", (INBT)this.item.func_77955_b(new CompoundNBT()));
        return nbt;
    }

    public int getPrimaryColor(GearType gearType, PartType partType) {
        IMaterialDisplay model = MaterialDisplayManager.get(this);
        MaterialLayer layer = model.getLayerList(gearType, partType, (IMaterialInstance)this).getFirstLayer();
        if (layer != null) {
            return layer.getColor();
        }
        return 0xFFFFFF;
    }

    @Override
    public ITextComponent getDisplayName(PartType partType, ItemStack gear) {
        return this.material.getDisplayName(this, partType, gear);
    }

    @Override
    public String getModelKey() {
        return this.material.getModelKey(this);
    }

    @Override
    public int getNameColor(PartType partType, GearType gearType) {
        return this.material.getNameColor(this, partType, gearType);
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_192572_a(this.material.getId());
        buffer.func_179249_a((Enum)this.grade);
    }

    @Nullable
    public static MaterialInstance readShorthand(String str) {
        if (str.contains("#")) {
            String[] parts = str.split("#");
            ResourceLocation id = SilentGear.getIdWithDefaultNamespace(parts[0]);
            IMaterial material = MaterialManager.get(id);
            if (material != null) {
                MaterialGrade grade = MaterialGrade.fromString(parts[1]);
                return new MaterialInstance(material, grade);
            }
            return null;
        }
        ResourceLocation id = SilentGear.getIdWithDefaultNamespace(str);
        IMaterial material = MaterialManager.get(id);
        if (material != null) {
            return new MaterialInstance(material);
        }
        return null;
    }

    public static String writeShorthand(IMaterialInstance material) {
        String id = SilentGear.shortenId(material.getId());
        if (material.getGrade() != MaterialGrade.NONE) {
            return id + "#" + (Object)((Object)material.getGrade());
        }
        return id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaterialInstance that = (MaterialInstance)o;
        return this.material.equals(that.material) && this.grade == that.grade && InventoryUtils.canItemsStack((ItemStack)this.item, (ItemStack)that.item);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.material, this.grade, this.item});
    }
}

