/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.gear.part.RepairContext;
import net.silentchaos512.gear.init.ModRecipes;
import net.silentchaos512.gear.item.RepairKitItem;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.lib.collection.StackList;

public class QuickRepairRecipe
extends SpecialRecipe {
    public QuickRepairRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        ItemStack gear = ItemStack.field_190927_a;
        boolean foundKit = false;
        float repairKitEfficiency = ((Double)Config.Common.missingRepairKitEfficiency.get()).floatValue();
        ArrayList<ItemStack> materials = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ICoreItem) {
                if (!gear.func_190926_b()) {
                    return false;
                }
                gear = stack;
                continue;
            }
            if (stack.func_77973_b() instanceof RepairKitItem) {
                if (foundKit) {
                    return false;
                }
                foundKit = true;
                repairKitEfficiency = QuickRepairRecipe.getKitEfficiency(stack);
                continue;
            }
            if (MaterialManager.from(stack) != null) {
                materials.add(stack);
                continue;
            }
            return false;
        }
        if (gear.func_190926_b() || (double)repairKitEfficiency < 1.0E-10) {
            return false;
        }
        for (ItemStack stack : materials) {
            if (ModRecipes.isRepairMaterial(gear, stack)) continue;
            return false;
        }
        return true;
    }

    private static float getKitEfficiency(ItemStack stack) {
        if (stack.func_77973_b() instanceof RepairKitItem) {
            return ((RepairKitItem)stack.func_77973_b()).getRepairEfficiency(RepairContext.Type.QUICK);
        }
        return ((Double)Config.Common.missingRepairKitEfficiency.get()).floatValue();
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        RepairKitItem item;
        int value;
        StackList list = StackList.from((IInventory)inv);
        ItemStack gear = list.uniqueOfType(ICoreItem.class).func_77946_l();
        ItemStack repairKit = list.uniqueOfType(RepairKitItem.class);
        Collection mats = list.allMatches(mat -> ModRecipes.isRepairMaterial(gear, mat));
        QuickRepairRecipe.repairWithLooseMaterials(gear, repairKit, mats);
        if (gear.func_77952_i() > 0 && repairKit.func_77973_b() instanceof RepairKitItem && (value = (item = (RepairKitItem)repairKit.func_77973_b()).getDamageToRepair(gear, repairKit, RepairContext.Type.QUICK)) > 0) {
            gear.func_196085_b(gear.func_77952_i() - Math.round(value));
        }
        GearData.incrementRepairCount(gear, 1);
        GearData.recalculateStats(gear, ForgeHooks.getCraftingPlayer());
        return gear;
    }

    private static void repairWithLooseMaterials(ItemStack gear, ItemStack repairKit, Collection<ItemStack> mats) {
        float repairValue = QuickRepairRecipe.getRepairValueFromMaterials(gear, mats);
        float kitEfficiency = QuickRepairRecipe.getKitEfficiency(repairKit);
        float gearRepairEfficiency = GearData.getStat(gear, ItemStats.REPAIR_EFFICIENCY);
        gear.func_196085_b(gear.func_77952_i() - Math.round(repairValue * kitEfficiency * gearRepairEfficiency));
    }

    private static float getRepairValueFromMaterials(ItemStack gear, Collection<ItemStack> mats) {
        float repairEfficiency;
        float repairValue = 0.0f;
        for (ItemStack stack : mats) {
            MaterialInstance material = MaterialInstance.from(stack);
            if (material == null) continue;
            repairValue += (float)material.getRepairValue(gear);
        }
        if (gear.func_77973_b() instanceof ICoreItem && (repairEfficiency = GearData.getStat(gear, ItemStats.REPAIR_EFFICIENCY)) > 0.0f) {
            repairValue *= repairEfficiency;
        }
        return repairValue;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList list = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        StackList stackList = StackList.from((IInventory)inv);
        ItemStack gear = stackList.uniqueMatch(s -> s.func_77973_b() instanceof ICoreItem);
        ItemStack repairKit = stackList.uniqueMatch(s -> s.func_77973_b() instanceof RepairKitItem);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_77973_b() instanceof RepairKitItem) {
                QuickRepairRecipe.repairWithLooseMaterials(gear, repairKit, stackList.allMatches(mat -> ModRecipes.isRepairMaterial(gear, mat)));
                RepairKitItem item = (RepairKitItem)stack.func_77973_b();
                ItemStack copy = stack.func_77946_l();
                item.removeRepairMaterials(copy, item.getRepairMaterials(gear, copy, RepairContext.Type.QUICK));
                list.set(i, (Object)copy);
                continue;
            }
            if (!stack.hasContainerItem()) continue;
            list.set(i, (Object)stack.getContainerItem());
        }
        return list;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public ResourceLocation func_199560_c() {
        return Const.QUICK_REPAIR;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.QUICK_REPAIR.get();
    }

    public static final class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<QuickRepairRecipe> {
        public QuickRepairRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new QuickRepairRecipe(recipeId);
        }

        public QuickRepairRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new QuickRepairRecipe(recipeId);
        }

        public void write(PacketBuffer buffer, QuickRepairRecipe recipe) {
        }
    }
}

