/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.ingredient;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialCategory;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.crafting.ingredient.IGearIngredient;
import net.silentchaos512.gear.gear.material.MaterialCategories;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.utils.Color;

public final class PartMaterialIngredient
extends Ingredient
implements IGearIngredient {
    private final PartType partType;
    private final GearType gearType;
    private final int minTier;
    private final int maxTier;
    private final Set<IMaterialCategory> categories = new LinkedHashSet<IMaterialCategory>();

    private PartMaterialIngredient(PartType partType, GearType gearType, int minTier, int maxTier) {
        super(Stream.of(new Ingredient.IItemList[0]));
        this.partType = partType;
        this.gearType = gearType;
        this.minTier = minTier;
        this.maxTier = maxTier;
    }

    public static PartMaterialIngredient of(PartType partType) {
        return PartMaterialIngredient.of(partType, GearType.TOOL);
    }

    public static PartMaterialIngredient of(PartType partType, IMaterialCategory ... categories) {
        return PartMaterialIngredient.of(partType, GearType.TOOL, categories);
    }

    public static PartMaterialIngredient of(PartType partType, GearType gearType) {
        return new PartMaterialIngredient(partType, gearType, 0, Integer.MAX_VALUE);
    }

    public static PartMaterialIngredient of(PartType partType, GearType gearType, IMaterialCategory ... categories) {
        return PartMaterialIngredient.of(partType, gearType, 0, Integer.MAX_VALUE, categories);
    }

    public static PartMaterialIngredient of(PartType partType, GearType gearType, int minTier, int maxTier) {
        return new PartMaterialIngredient(partType, gearType, minTier, maxTier);
    }

    public static PartMaterialIngredient of(PartType partType, GearType gearType, int minTier, int maxTier, IMaterialCategory ... categories) {
        PartMaterialIngredient ret = new PartMaterialIngredient(partType, gearType, minTier, maxTier);
        ret.categories.addAll(Arrays.asList(categories));
        return ret;
    }

    @Override
    public PartType getPartType() {
        return this.partType;
    }

    @Override
    public GearType getGearType() {
        return this.gearType;
    }

    @Override
    public Optional<ITextComponent> getJeiHint() {
        IFormattableTextComponent text;
        if (!this.categories.isEmpty()) {
            StringTextComponent cats = new StringTextComponent(this.categories.stream().map(IMaterialCategory::getName).collect(Collectors.joining(", ")));
            text = TextUtil.withColor((IFormattableTextComponent)cats, Color.INDIANRED);
        } else {
            StringTextComponent any = new StringTextComponent("any");
            text = TextUtil.withColor((IFormattableTextComponent)any, Color.LIGHTGREEN);
        }
        PartGearKey key = PartGearKey.of(this.gearType, this.partType);
        text.func_230529_a_((ITextComponent)TextUtil.misc("spaceBrackets", key.toString()).func_240699_a_(TextFormatting.GRAY));
        return Optional.of(TextUtil.translate("jei", "materialType", text));
    }

    public Set<IMaterialCategory> getCategories() {
        return Collections.unmodifiableSet(this.categories);
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        MaterialInstance material = MaterialInstance.from(stack);
        if (material == null) {
            return false;
        }
        int tier = material.getTier(this.partType);
        return material.get().isCraftingAllowed(material, this.partType, this.gearType) && (this.categories.isEmpty() || material.hasAnyCategory(this.categories)) && this.tierMatches(tier);
    }

    private boolean tierMatches(int tier) {
        return tier >= this.minTier && tier <= this.maxTier;
    }

    public ItemStack[] func_193365_a() {
        List<IMaterial> materials = MaterialManager.getValues();
        if (!materials.isEmpty()) {
            return (ItemStack[])materials.stream().map(MaterialInstance::of).filter(mat -> mat.get().isCraftingAllowed(mat, this.partType, this.gearType)).filter(mat -> this.categories.isEmpty() || mat.hasAnyCategory(this.categories)).filter(mat -> this.tierMatches(mat.getTier(this.partType))).flatMap(mat -> Stream.of(mat.get().getIngredient().func_193365_a())).filter(stack -> !stack.func_190926_b()).toArray(ItemStack[]::new);
        }
        return super.func_193365_a();
    }

    public boolean isSimple() {
        return false;
    }

    public boolean func_203189_d() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Serializer.NAME.toString());
        json.addProperty("part_type", this.partType.getName().toString());
        if (this.gearType != GearType.TOOL) {
            json.addProperty("gear_type", this.gearType.getName());
        }
        if (!this.categories.isEmpty()) {
            JsonArray array = new JsonArray();
            this.categories.forEach(cat -> array.add(cat.getName()));
            json.add("categories", (JsonElement)array);
        }
        if (this.minTier > 0) {
            json.addProperty("min_tier", (Number)this.minTier);
        }
        if (this.maxTier < Integer.MAX_VALUE) {
            json.addProperty("max_tier", (Number)this.maxTier);
        }
        return json;
    }

    public static final class Serializer
    implements IIngredientSerializer<PartMaterialIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation NAME = SilentGear.getId("material");

        private Serializer() {
        }

        public PartMaterialIngredient parse(PacketBuffer buffer) {
            ResourceLocation typeName = buffer.func_192575_l();
            PartType partType = PartType.get(typeName);
            if (partType == null) {
                throw new JsonParseException("Unknown part type: " + typeName);
            }
            GearType gearType = GearType.get(buffer.func_218666_n());
            if (gearType.isInvalid()) {
                throw new JsonParseException("Unknown gear type: " + typeName);
            }
            int categoryCount = buffer.readByte();
            IMaterialCategory[] categories = new IMaterialCategory[categoryCount];
            for (int i = 0; i < categoryCount; ++i) {
                categories[i] = MaterialCategories.get(buffer.func_218666_n());
            }
            int minTier = buffer.func_150792_a();
            int maxTier = buffer.func_150792_a();
            return PartMaterialIngredient.of(partType, gearType, minTier, maxTier, categories);
        }

        public PartMaterialIngredient parse(JsonObject json) {
            String typeName = JSONUtils.func_151219_a((JsonObject)json, (String)"part_type", (String)"");
            if (typeName.isEmpty()) {
                throw new JsonSyntaxException("'part_type' is missing");
            }
            PartType type = PartType.get(Objects.requireNonNull(SilentGear.getIdWithDefaultNamespace(typeName)));
            if (type == null) {
                throw new JsonSyntaxException("part_type " + typeName + " does not exist");
            }
            String gearTypeName = JSONUtils.func_151219_a((JsonObject)json, (String)"gear_type", (String)"tool");
            GearType gearType = GearType.get(gearTypeName);
            if (gearType.isInvalid()) {
                throw new JsonSyntaxException("gear_type " + gearTypeName + " does not exist");
            }
            ArrayList<IMaterialCategory> categories = new ArrayList<IMaterialCategory>();
            if (json.has("categories")) {
                JsonArray array = json.getAsJsonArray("categories");
                for (JsonElement element : array) {
                    categories.add(MaterialCategories.get(element.getAsString()));
                }
            }
            int minTier = JSONUtils.func_151208_a((JsonObject)json, (String)"min_tier", (int)0);
            int maxTier = JSONUtils.func_151208_a((JsonObject)json, (String)"max_tier", (int)Integer.MAX_VALUE);
            PartMaterialIngredient ret = PartMaterialIngredient.of(type, gearType, minTier, maxTier);
            ret.categories.addAll(categories);
            return ret;
        }

        public void write(PacketBuffer buffer, PartMaterialIngredient ingredient) {
            buffer.func_192572_a(ingredient.partType.getName());
            buffer.func_180714_a(ingredient.gearType.getName());
            buffer.writeByte(ingredient.categories.size());
            ingredient.categories.forEach(cat -> buffer.func_180714_a(cat.getName()));
            buffer.func_150787_b(ingredient.minTier);
            buffer.func_150787_b(ingredient.maxTier);
        }
    }
}

