/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.compat.jei;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.block.compounder.MetalAlloyerScreen;
import net.silentchaos512.gear.block.compounder.RecrystallizerScreen;
import net.silentchaos512.gear.block.compounder.RefabricatorScreen;
import net.silentchaos512.gear.block.grader.GraderScreen;
import net.silentchaos512.gear.block.salvager.SalvagerScreen;
import net.silentchaos512.gear.compat.jei.CompoundingRecipeCategory;
import net.silentchaos512.gear.compat.jei.GearCraftingRecipeCategoryJei;
import net.silentchaos512.gear.compat.jei.MaterialGraderRecipeCategory;
import net.silentchaos512.gear.compat.jei.SalvagingRecipeCategoryJei;
import net.silentchaos512.gear.crafting.ingredient.PartMaterialIngredient;
import net.silentchaos512.gear.crafting.recipe.compounder.CompoundingRecipe;
import net.silentchaos512.gear.crafting.recipe.compounder.FabricCompoundingRecipe;
import net.silentchaos512.gear.crafting.recipe.compounder.GemCompoundingRecipe;
import net.silentchaos512.gear.crafting.recipe.compounder.MetalCompoundingRecipe;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.init.ModRecipes;
import net.silentchaos512.gear.init.Registration;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.item.CustomMaterialItem;
import net.silentchaos512.gear.item.FragmentItem;
import net.silentchaos512.gear.item.RepairKitItem;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.lib.util.NameUtils;

@JeiPlugin
public class SGearJeiPlugin
implements IModPlugin {
    private static final ResourceLocation PLUGIN_UID = SilentGear.getId("plugin/main");
    static final ResourceLocation GEAR_CRAFTING = SilentGear.getId("category/gear_crafting");

    public ResourceLocation getPluginUid() {
        return PLUGIN_UID;
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        IGuiHelper guiHelper = reg.getJeiHelpers().getGuiHelper();
        reg.addRecipeCategories(new IRecipeCategory[]{new GearCraftingRecipeCategoryJei(guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new CompoundingRecipeCategory<FabricCompoundingRecipe>(Const.FABRIC_COMPOUNDER_INFO, "fabric", guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new CompoundingRecipeCategory<GemCompoundingRecipe>(Const.GEM_COMPOUNDER_INFO, "gem", guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new CompoundingRecipeCategory<MetalCompoundingRecipe>(Const.METAL_COMPOUNDER_INFO, "metal", guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new MaterialGraderRecipeCategory(guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new SalvagingRecipeCategoryJei(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration reg) {
        assert (Minecraft.func_71410_x().field_71441_e != null);
        RecipeManager recipeManager = Minecraft.func_71410_x().field_71441_e.func_199532_z();
        for (RepairKitItem repairKitItem : Registration.getItems(RepairKitItem.class)) {
            String itemName = NameUtils.fromItem((IItemProvider)repairKitItem).func_110623_a();
            reg.addRecipes(Collections.singleton(new ShapelessRecipe((ResourceLocation)SilentGear.getId(itemName + "_fill_hint"), "", new ItemStack((IItemProvider)repairKitItem), NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{repairKitItem}), PartMaterialIngredient.of(PartType.MAIN), PartMaterialIngredient.of(PartType.MAIN), PartMaterialIngredient.of(PartType.MAIN)}))), VanillaRecipeCategoryUid.CRAFTING);
            reg.addRecipes(Collections.singleton(new ShapelessRecipe((ResourceLocation)SilentGear.getId(itemName + "_fill_hint_frag"), "", new ItemStack((IItemProvider)repairKitItem), NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{repairKitItem}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModItems.FRAGMENT}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModItems.FRAGMENT}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModItems.FRAGMENT})}))), VanillaRecipeCategoryUid.CRAFTING);
        }
        reg.addRecipes((Collection)recipeManager.func_199510_b().stream().filter(SGearJeiPlugin::isGearCraftingRecipe).collect(Collectors.toList()), GEAR_CRAFTING);
        reg.addRecipes((Collection)recipeManager.func_199510_b().stream().filter(r -> r.func_222127_g() == ModRecipes.COMPOUNDING_FABRIC_TYPE).collect(Collectors.toList()), Const.COMPOUNDING_FABRIC);
        reg.addRecipes((Collection)recipeManager.func_199510_b().stream().filter(r -> r.func_222127_g() == ModRecipes.COMPOUNDING_GEM_TYPE).collect(Collectors.toList()), Const.COMPOUNDING_GEM);
        reg.addRecipes((Collection)recipeManager.func_199510_b().stream().filter(r -> r.func_222127_g() == ModRecipes.COMPOUNDING_METAL_TYPE).collect(Collectors.toList()), Const.COMPOUNDING_METAL);
        for (int i = 2; i <= 4; ++i) {
            reg.addRecipes(Collections.singleton(CompoundingRecipe.makeExample(Const.FABRIC_COMPOUNDER_INFO, i, new FabricCompoundingRecipe(SilentGear.getId("fabric_example_" + i)))), Const.COMPOUNDING_FABRIC);
            reg.addRecipes(Collections.singleton(CompoundingRecipe.makeExample(Const.GEM_COMPOUNDER_INFO, i, new GemCompoundingRecipe(SilentGear.getId("gem_example_" + i)))), Const.COMPOUNDING_GEM);
            reg.addRecipes(Collections.singleton(CompoundingRecipe.makeExample(Const.METAL_COMPOUNDER_INFO, i, new MetalCompoundingRecipe(SilentGear.getId("metal_example_" + i)))), Const.COMPOUNDING_METAL);
        }
        reg.addRecipes(Collections.singleton(new MaterialGraderRecipeCategory.GraderRecipe()), Const.GRADING);
        reg.addRecipes((Collection)recipeManager.func_199510_b().stream().filter(r -> r.func_222127_g() == ModRecipes.SALVAGING_TYPE).collect(Collectors.toList()), Const.SALVAGING);
        SGearJeiPlugin.addInfoPage(reg, CraftingItems.RED_CARD_UPGRADE);
        SGearJeiPlugin.addInfoPage(reg, CraftingItems.SPOON_UPGRADE);
        for (Item item2 : Registration.getItems(item -> item instanceof ICoreTool)) {
            SGearJeiPlugin.addInfoPage(reg, (IItemProvider)item2);
        }
    }

    private static boolean isGearCraftingRecipe(IRecipe<?> recipe) {
        IRecipeSerializer serializer = recipe.func_199559_b();
        return serializer == ModRecipes.SHAPED_GEAR.get() || serializer == ModRecipes.SHAPELESS_GEAR.get() || serializer == ModRecipes.COMPOUND_PART.get();
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        reg.addRecipeCatalyst((Object)new ItemStack((IItemProvider)Blocks.field_150462_ai), new ResourceLocation[]{GEAR_CRAFTING});
        reg.addRecipeCatalyst((Object)new ItemStack(ModBlocks.REFABRICATOR), new ResourceLocation[]{Const.COMPOUNDING_FABRIC});
        reg.addRecipeCatalyst((Object)new ItemStack(ModBlocks.RECRYSTALLIZER), new ResourceLocation[]{Const.COMPOUNDING_GEM});
        reg.addRecipeCatalyst((Object)new ItemStack(ModBlocks.METAL_ALLOYER), new ResourceLocation[]{Const.COMPOUNDING_METAL});
        reg.addRecipeCatalyst((Object)new ItemStack(ModBlocks.MATERIAL_GRADER), new ResourceLocation[]{Const.GRADING});
        reg.addRecipeCatalyst((Object)new ItemStack(ModBlocks.SALVAGER), new ResourceLocation[]{Const.SALVAGING});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration reg) {
        reg.addRecipeClickArea(RefabricatorScreen.class, 90, 30, 28, 23, new ResourceLocation[]{Const.COMPOUNDING_FABRIC});
        reg.addRecipeClickArea(RecrystallizerScreen.class, 90, 30, 28, 23, new ResourceLocation[]{Const.COMPOUNDING_GEM});
        reg.addRecipeClickArea(MetalAlloyerScreen.class, 90, 30, 28, 23, new ResourceLocation[]{Const.COMPOUNDING_METAL});
        reg.addRecipeClickArea(GraderScreen.class, 48, 30, 28, 23, new ResourceLocation[]{Const.GRADING});
        reg.addRecipeClickArea(SalvagerScreen.class, 30, 30, 28, 23, new ResourceLocation[]{Const.SALVAGING});
    }

    public void registerItemSubtypes(ISubtypeRegistration reg) {
        reg.registerSubtypeInterpreter((Item)ModItems.FRAGMENT.get(), stack -> {
            IMaterialInstance material = FragmentItem.getMaterial(stack);
            return material != null ? material.getId().toString() : "";
        });
        ISubtypeInterpreter customMaterials = stack -> {
            MaterialInstance material = CustomMaterialItem.getMaterial(stack);
            return material != null ? material.getId().toString() : "";
        };
        reg.registerSubtypeInterpreter((Item)ModItems.CUSTOM_GEM.get(), customMaterials);
        reg.registerSubtypeInterpreter((Item)ModItems.CUSTOM_INGOT.get(), customMaterials);
    }

    private static void addInfoPage(IRecipeRegistration reg, IItemProvider item) {
        String key = SGearJeiPlugin.getDescKey(Objects.requireNonNull(item.func_199767_j().getRegistryName()));
        ItemStack stack = new ItemStack(item);
        reg.addIngredientInfo((Object)stack, VanillaTypes.ITEM, new String[]{key});
    }

    private static void addInfoPage(IRecipeRegistration reg, String name, Collection<IItemProvider> items) {
        String key = SGearJeiPlugin.getDescKey(SilentGear.getId(name));
        List stacks = items.stream().map(ItemStack::new).collect(Collectors.toList());
        reg.addIngredientInfo(stacks, VanillaTypes.ITEM, new String[]{key});
    }

    private static void addInfoPage(IRecipeRegistration reg, IItemProvider item, Stream<ItemStack> variants) {
        String key = SGearJeiPlugin.getDescKey(Objects.requireNonNull(item.func_199767_j().getRegistryName()));
        reg.addIngredientInfo(variants.collect(Collectors.toList()), VanillaTypes.ITEM, new String[]{key});
    }

    private static String getDescKey(ResourceLocation name) {
        return "jei." + name.func_110624_b() + "." + name.func_110623_a() + ".desc";
    }
}

