/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.model.fragment;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.geometry.IModelGeometryPart;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.MaterialLayer;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.client.material.MaterialDisplayManager;
import net.silentchaos512.gear.client.model.BakedPerspectiveModel;
import net.silentchaos512.gear.client.model.BakedWrapper;
import net.silentchaos512.gear.client.model.LayeredModel;
import net.silentchaos512.gear.client.model.PartTextures;
import net.silentchaos512.gear.client.model.fragment.FragmentModelOverrideList;
import net.silentchaos512.gear.gear.material.LazyMaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.util.Const;

public class FragmentModel
extends LayeredModel<FragmentModel> {
    private final ItemCameraTransforms cameraTransforms;
    private FragmentModelOverrideList overrideList;

    public FragmentModel(ItemCameraTransforms cameraTransforms) {
        this.cameraTransforms = cameraTransforms;
    }

    public void clearCache() {
        if (this.overrideList != null) {
            this.overrideList.clearCache();
        }
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        this.overrideList = new FragmentModelOverrideList(this, owner, bakery, spriteGetter, modelTransform, modelLocation);
        return new BakedWrapper(this, owner, bakery, spriteGetter, modelTransform, modelLocation, this.overrideList);
    }

    public IBakedModel bake(List<MaterialLayer> layers, IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, FragmentModelOverrideList fragmentModelOverrideList, ResourceLocation modelLocation) {
        ImmutableList.Builder builder = ImmutableList.builder();
        TransformationMatrix rotation = modelTransform.func_225615_b_();
        ImmutableMap transforms = PerspectiveMapWrapper.getTransforms((IModelTransform)modelTransform);
        for (int i = 0; i < layers.size(); ++i) {
            MaterialLayer layer = layers.get(i);
            TextureAtlasSprite texture = spriteGetter.apply(new RenderMaterial(PlayerContainer.field_226615_c_, layer.getTexture(GearType.FRAGMENT, 0)));
            builder.addAll(FragmentModel.getQuadsForSprite(i, texture, rotation, layer.getColor()));
        }
        if (layers.isEmpty()) {
            if (Const.Materials.EXAMPLE.isPresent()) {
                this.buildFakeModel(spriteGetter, (ImmutableList.Builder<BakedQuad>)builder, rotation, Const.Materials.EXAMPLE.get());
            } else {
                SilentGear.LOGGER.error("Example material is missing?");
                TextureAtlasSprite texture = spriteGetter.apply(new RenderMaterial(PlayerContainer.field_226615_c_, (ResourceLocation)SilentGear.getId("item/error")));
                builder.addAll(FragmentModel.getQuadsForSprite(0, texture, rotation, 0xFFFFFF));
            }
        }
        TextureAtlasSprite particle = spriteGetter.apply(owner.resolveTexture("particle"));
        return new BakedPerspectiveModel((ImmutableList<BakedQuad>)builder.build(), particle, (ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix>)transforms, this.overrideList, rotation.isIdentity(), owner.isSideLit(), this.cameraTransforms);
    }

    private void buildFakeModel(Function<RenderMaterial, TextureAtlasSprite> spriteGetter, ImmutableList.Builder<BakedQuad> builder, TransformationMatrix rotation, IMaterial material) {
        MaterialInstance mat = MaterialInstance.of(material);
        IMaterialDisplay model = MaterialDisplayManager.get(mat);
        MaterialLayer exampleMain = model.getLayerList(GearType.FRAGMENT, PartType.MAIN, (IMaterialInstance)mat).getFirstLayer();
        if (exampleMain != null) {
            builder.addAll(FragmentModel.getQuadsForSprite(0, spriteGetter.apply(new RenderMaterial(PlayerContainer.field_226615_c_, exampleMain.getTexture(GearType.FRAGMENT, 0))), rotation, exampleMain.getColor()));
        }
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet<RenderMaterial> ret = new HashSet<RenderMaterial>();
        ret.add(new RenderMaterial(PlayerContainer.field_226615_c_, (ResourceLocation)SilentGear.getId("item/error")));
        ret.add(this.getTexture(PartTextures.CLOTH.getTexture()));
        ret.add(this.getTexture(PartTextures.METAL.getTexture()));
        ret.add(this.getTexture(PartTextures.WOOD.getTexture()));
        for (IMaterialDisplay materialDisplay : MaterialDisplayManager.getMaterials()) {
            for (MaterialLayer layer : materialDisplay.getLayerList(GearType.FRAGMENT, PartType.MAIN, (IMaterialInstance)LazyMaterialInstance.of(materialDisplay.getMaterialId()))) {
                ret.add(this.getTexture(layer));
            }
        }
        SilentGear.LOGGER.info("Textures for fragment model");
        for (RenderMaterial mat : ret) {
            SilentGear.LOGGER.info("- {}", (Object)mat.func_229313_b_());
        }
        return ret;
    }

    private RenderMaterial getTexture(MaterialLayer layer) {
        return FragmentModel.getMaterial(layer.getTexture(GearType.FRAGMENT, 0));
    }

    private RenderMaterial getTexture(ResourceLocation tex) {
        String path = "item/" + GearType.FRAGMENT.getName() + "/" + tex.func_110623_a();
        ResourceLocation location = new ResourceLocation(tex.func_110624_b(), path);
        return FragmentModel.getMaterial(location);
    }

    private static RenderMaterial getMaterial(ResourceLocation tex) {
        return new RenderMaterial(PlayerContainer.field_226615_c_, tex);
    }

    public Collection<? extends IModelGeometryPart> getParts() {
        return Collections.emptyList();
    }

    public Optional<? extends IModelGeometryPart> getPart(String name) {
        return Optional.empty();
    }
}

