/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.event;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;

public final class ExtraBlockBreakHandler
implements ISelectiveResourceReloadListener {
    public static final ExtraBlockBreakHandler INSTANCE = new ExtraBlockBreakHandler(Minecraft.func_71410_x());
    private final Map<Integer, DestroyExtraBlocksProgress> extraDamagedBlocks = new HashMap<Integer, DestroyExtraBlocksProgress>();
    private Minecraft mc;

    private ExtraBlockBreakHandler(Minecraft mcIn) {
        this.mc = mcIn;
    }

    @SubscribeEvent
    public void renderBlockBreakAnim(RenderWorldLastEvent event) {
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        this.extraDamagedBlocks.clear();
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        this.extraDamagedBlocks.clear();
    }

    private static void preRenderDamagedBlocks() {
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        RenderSystem.polygonOffset((float)-3.0f, (float)-3.0f);
        RenderSystem.enablePolygonOffset();
        RenderSystem.alphaFunc((int)516, (float)0.1f);
        RenderSystem.enableAlphaTest();
        RenderSystem.pushMatrix();
    }

    private static void postRenderDamagedBlocks() {
        RenderSystem.disableAlphaTest();
        RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
        RenderSystem.disablePolygonOffset();
        RenderSystem.enableAlphaTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.popMatrix();
    }

    private void drawBlockDamageTexture(Tessellator tessellatorIn, BufferBuilder bufferBuilderIn, Entity entityIn, float partialTicks) {
    }

    private void cleanupExtraDamagedBlocks() {
        for (Map.Entry<Integer, DestroyExtraBlocksProgress> entry : this.extraDamagedBlocks.entrySet()) {
            DestroyExtraBlocksProgress destroyblockprogress = entry.getValue();
            int k1 = destroyblockprogress.getCreationWorldTick();
            if (this.mc.field_71441_e.func_82737_E() - (long)k1 <= 400L) continue;
            this.extraDamagedBlocks.remove(entry.getKey());
        }
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
    }

    public void sendBlockBreakProgress(int breakerId, BlockPos[] positions, int progress) {
        if (positions.length > 0 && progress >= 0 && progress < 10) {
            DestroyExtraBlocksProgress destroyextrablocksprogress = new DestroyExtraBlocksProgress(breakerId, positions);
            this.extraDamagedBlocks.put(breakerId, destroyextrablocksprogress);
            destroyextrablocksprogress.setPartialBlockDamage(progress);
            destroyextrablocksprogress.setWorldTick((int)this.mc.field_71441_e.func_82737_E());
        } else {
            this.extraDamagedBlocks.remove(breakerId);
        }
    }

    private static class DestroyExtraBlocksProgress {
        private final int miningPlayerEntId;
        private final BlockPos[] positions;
        private int partialBlockProgress;
        private int createdAtWorldTick;

        public DestroyExtraBlocksProgress(int miningPlayerEntIdIn, BlockPos ... positionsIn) {
            this.miningPlayerEntId = miningPlayerEntIdIn;
            this.positions = positionsIn;
        }

        public BlockPos[] getPositions() {
            return this.positions;
        }

        public void setPartialBlockDamage(int damage) {
            if (damage > 10) {
                damage = 10;
            }
            this.partialBlockProgress = damage;
        }

        public int getPartialBlockDamage() {
            return this.partialBlockProgress;
        }

        public void setWorldTick(int createdAtWorldTickIn) {
            this.createdAtWorldTick = createdAtWorldTickIn;
        }

        public int getCreationWorldTick() {
            return this.createdAtWorldTick;
        }
    }
}

