/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.silentchaos512.gear.init.ModTags;

public class FluffyBlock
extends Block {
    private final DyeColor dyeColor;

    public FluffyBlock(DyeColor color) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151580_n).func_200948_a(0.8f, 3.0f).func_200947_a(SoundType.field_185854_g));
        this.dyeColor = color;
    }

    public DyeColor getDyeColor() {
        return this.dyeColor;
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float distance) {
        int stackedBlocks;
        if (distance < 2.0f || world.field_72995_K) {
            return;
        }
        for (stackedBlocks = 0; stackedBlocks < 10 && world.func_180495_p(pos).func_235714_a_(ModTags.Blocks.FLUFFY_BLOCKS); ++stackedBlocks) {
            pos = pos.func_177977_b();
        }
        float newDistance = distance - Math.min((float)(8 * stackedBlocks), distance);
        entity.field_70143_R = 0.0f;
        entity.func_225503_b_(newDistance, 1.0f);
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        if (entityIn.func_226272_bl_()) {
            super.func_176216_a(worldIn, entityIn);
        } else {
            FluffyBlock.bounceEntity(entityIn);
        }
    }

    private static void bounceEntity(Entity entity) {
        Vector3d vector3d = entity.func_213322_ci();
        if (vector3d.field_72448_b < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.func_213293_j(vector3d.field_72450_a, -vector3d.field_72448_b * 0.5 * d0, vector3d.field_72449_c);
        }
    }

    private static void onGetBreakSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack mainHand = event.getPlayer().func_184586_b(Hand.MAIN_HAND);
        if (!mainHand.func_190926_b() && mainHand.func_77973_b() instanceof ShearsItem) {
            int efficiency = EnchantmentHelper.func_185293_e((LivingEntity)event.getPlayer());
            float speed = event.getNewSpeed() * 4.0f;
            if (efficiency > 0) {
                speed += (float)(efficiency * efficiency + 1);
            }
            event.setNewSpeed(speed);
        }
    }

    static {
        MinecraftForge.EVENT_BUS.addListener(FluffyBlock::onGetBreakSpeed);
    }
}

