/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.traits;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.traits.ITraitInstance;
import net.silentchaos512.gear.api.traits.LazyTraitInstance;
import net.silentchaos512.gear.client.KeyTracker;
import net.silentchaos512.gear.gear.trait.TraitManager;
import net.silentchaos512.gear.gear.trait.TraitSerializers;
import net.silentchaos512.gear.util.DataResource;
import net.silentchaos512.gear.util.TextUtil;

public final class TraitInstance
implements ITraitInstance {
    private final ITrait trait;
    private final int level;
    private final ImmutableList<ITraitCondition> conditions;

    private TraitInstance(ITrait trait, int level, ITraitCondition ... conditions) {
        this.trait = trait;
        this.level = level;
        this.conditions = ImmutableList.builder().add((Object[])this.trait.getConditions().toArray(new ITraitCondition[0])).add((Object[])conditions).build();
    }

    public static ITraitInstance of(DataResource<ITrait> trait, int level, ITraitCondition ... conditions) {
        if (trait.isPresent()) {
            return TraitInstance.of(trait.get(), level, conditions);
        }
        return TraitInstance.lazy(trait.getId(), level, conditions);
    }

    public static TraitInstance of(ITrait trait, int level, ITraitCondition ... conditions) {
        return new TraitInstance(trait, level, conditions);
    }

    public static LazyTraitInstance lazy(ResourceLocation traitId, int level, ITraitCondition ... conditions) {
        return new LazyTraitInstance(traitId, level, conditions);
    }

    @Override
    public ResourceLocation getTraitId() {
        return this.trait.getId();
    }

    @Override
    @Nonnull
    public ITrait getTrait() {
        return this.trait;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public Collection<ITraitCondition> getConditions() {
        return this.conditions;
    }

    public IFormattableTextComponent getDisplayName() {
        IFormattableTextComponent text = this.trait.getDisplayName(this.level).func_230532_e_();
        if (!this.conditions.isEmpty()) {
            text.func_240702_b_("*");
        }
        return text;
    }

    public void addInformation(List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (!this.trait.showInTooltip(flag)) {
            return;
        }
        IFormattableTextComponent displayName = this.getDisplayName().func_240699_a_(TextFormatting.ITALIC);
        tooltip.add((ITextComponent)(this.trait.isHidden() ? TextUtil.withColor(displayName, TextFormatting.DARK_GRAY) : displayName));
        if (KeyTracker.isAltDown()) {
            IFormattableTextComponent description = TextUtil.withColor(this.trait.getDescription(this.level), TextFormatting.DARK_GRAY);
            tooltip.add((ITextComponent)new StringTextComponent("    ").func_230529_a_((ITextComponent)description));
        }
    }

    public static TraitInstance deserialize(JsonObject json) {
        ResourceLocation traitId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"name"));
        ITrait trait = TraitManager.get(traitId);
        if (trait == null) {
            throw new JsonSyntaxException("Unknown trait: " + traitId);
        }
        int level = MathHelper.func_76125_a((int)JSONUtils.func_151208_a((JsonObject)json, (String)"level", (int)1), (int)1, (int)trait.getMaxLevel());
        ArrayList<ITraitCondition> conditions = new ArrayList<ITraitCondition>();
        if (json.has("conditions")) {
            JsonArray array = json.getAsJsonArray("conditions");
            for (JsonElement j : array) {
                conditions.add(TraitSerializers.deserializeCondition(j.getAsJsonObject()));
            }
        }
        return TraitInstance.of(trait, level, conditions.toArray(new ITraitCondition[0]));
    }

    public static TraitInstance read(PacketBuffer buffer) {
        ResourceLocation traitId = buffer.func_192575_l();
        ITrait trait = TraitManager.get(traitId);
        if (trait == null) {
            throw new IllegalStateException("Unknown trait: " + traitId);
        }
        byte level = buffer.readByte();
        ITraitCondition[] conditions = new ITraitCondition[buffer.readByte()];
        for (int i = 0; i < conditions.length; ++i) {
            conditions[i] = TraitSerializers.readCondition(buffer);
        }
        return TraitInstance.of(trait, (int)level, conditions);
    }

    public void write(PacketBuffer buffer) {
        buffer.func_192572_a(this.getTraitId());
        buffer.writeByte(this.level);
        buffer.writeByte(this.conditions.size());
        this.conditions.forEach(condition -> TraitSerializers.writeCondition(condition, buffer));
    }
}

