/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.part;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterialLayerList;
import net.silentchaos512.gear.api.material.MaterialLayerList;
import net.silentchaos512.gear.api.part.IPartData;
import net.silentchaos512.gear.api.part.IPartDisplay;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.util.PartGearKey;

public class PartDisplay
implements IPartDisplay {
    protected final Map<PartGearKey, MaterialLayerList> map = new LinkedHashMap<PartGearKey, MaterialLayerList>();
    private PartType partType = PartType.NONE;

    public static PartDisplay of(Map<PartGearKey, MaterialLayerList> display) {
        PartDisplay model = new PartDisplay();
        if (!display.isEmpty()) {
            model.partType = display.keySet().iterator().next().getPartType();
        }
        display.forEach(model.map::put);
        return model;
    }

    @Override
    public IMaterialLayerList getLayers(GearType gearType, IPartData part) {
        return this.map.getOrDefault(this.getMostSpecificKey(gearType), MaterialLayerList.DEFAULT);
    }

    private PartGearKey getMostSpecificKey(GearType gearType) {
        PartGearKey key = PartGearKey.of(gearType, this.partType);
        if (this.map.containsKey(key)) {
            return key;
        }
        for (PartGearKey parent = key.getParent(); parent != null; parent = parent.getParent()) {
            if (!this.map.containsKey(parent)) continue;
            return parent;
        }
        return key;
    }

    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        this.map.forEach((key, layerList) -> json.add(key.toString(), layerList.serialize()));
        return json;
    }

    public static PartDisplay deserialize(ResourceLocation modelId, JsonObject json) {
        PartDisplay ret = new PartDisplay();
        json.entrySet().forEach(entry -> {
            PartGearKey key = PartGearKey.read((String)entry.getKey());
            JsonElement value = (JsonElement)entry.getValue();
            ret.partType = key.getPartType();
            ret.map.put(key, MaterialLayerList.deserialize(key, value, MaterialLayerList.DEFAULT));
        });
        return ret;
    }
}

