/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.part;

import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.MaterialList;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.IGearComponentInstance;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.api.util.StatGearKey;

public interface IPartData
extends IGearComponentInstance<IGearPart> {
    @Deprecated
    default public ResourceLocation getPartId() {
        return this.getId();
    }

    @Deprecated
    @Nullable
    default public IGearPart getPart() {
        return (IGearPart)this.get();
    }

    @Deprecated
    default public ItemStack getCraftingItem() {
        return this.getItem();
    }

    public CompoundNBT write(CompoundNBT var1);

    default public int getTier() {
        IGearPart part = (IGearPart)this.get();
        return part != null ? part.getTier() : 0;
    }

    default public PartType getType() {
        IGearPart part = (IGearPart)this.get();
        return part != null ? part.getType() : PartType.NONE;
    }

    default public GearType getGearType() {
        IGearPart part = (IGearPart)this.get();
        return part != null ? part.getGearType() : GearType.ALL;
    }

    @Override
    default public MaterialList getMaterials() {
        IGearPart part = (IGearPart)this.get();
        return part != null ? part.getMaterials(this) : MaterialList.empty();
    }

    @Override
    default public float getStat(PartType partType, StatGearKey key, ItemStack gear) {
        ItemStat stat = ItemStats.get(key.getStat());
        if (stat == null) {
            return key.getStat().getDefaultValue();
        }
        return stat.compute(stat.getDefaultValue(), this.getStatModifiers(partType, key));
    }

    default public Collection<StatInstance> getStatModifiers(StatGearKey key, ItemStack gear) {
        return this.getStatModifiers(this.getType(), key, gear);
    }

    @Override
    default public Collection<StatInstance> getStatModifiers(PartType partType, StatGearKey key, ItemStack gear) {
        IGearPart part = (IGearPart)this.get();
        if (part == null) {
            return Collections.emptyList();
        }
        return part.getStatModifiers(this, this.getType(), key, gear);
    }

    default public Collection<TraitInstance> getTraits() {
        return this.getTraits(this.getType(), this.getGearType(), ItemStack.field_190927_a);
    }

    default public Collection<TraitInstance> getTraits(ItemStack gear) {
        return this.getTraits(this.getType(), this.getGearType(), gear);
    }

    @Override
    default public Collection<TraitInstance> getTraits(PartType partType, GearType gearType, ItemStack gear) {
        IGearPart part = (IGearPart)this.get();
        if (part == null) {
            return Collections.emptyList();
        }
        return part.getTraits(this, PartGearKey.of(gearType, partType), gear);
    }

    @Override
    default public int getNameColor(PartType partType, GearType gearType) {
        return 0xFFFFFF;
    }

    public String getModelKey();

    default public void onAddToGear(ItemStack gear) {
    }

    default public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("part", this.getId().toString());
        ItemStack stack = this.getItem();
        if (!stack.func_190926_b()) {
            // empty if block
        }
        return json;
    }
}

