/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.material;

import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.IMaterialLayerList;
import net.silentchaos512.gear.api.material.MaterialLayer;
import net.silentchaos512.gear.api.part.IPartData;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.gear.part.FakePartData;

public interface IMaterialDisplay {
    public ResourceLocation getMaterialId();

    public IMaterialLayerList getLayerList(GearType var1, IPartData var2, IMaterialInstance var3);

    default public IMaterialLayerList getLayerList(GearType gearType, PartType partType, IMaterialInstance materialIn) {
        return this.getLayerList(gearType, FakePartData.of(partType), materialIn);
    }

    default public int getLayerColor(GearType gearType, IPartData part, IMaterialInstance materialIn, int layer) {
        List<MaterialLayer> layers = this.getLayerList(gearType, part, materialIn).getLayers();
        return layer < layers.size() ? layers.get(layer).getColor() : 0xFFFFFF;
    }

    default public int getLayerColor(GearType gearType, PartType partType, IMaterialInstance materialIn, int layer) {
        return this.getLayerColor(gearType, FakePartData.of(partType), materialIn, layer);
    }
}

