/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.util;

import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class ListView<T>
implements Iterable<T> {
    private final Iterable<T> collection;
    private final Predicate<T> filter;

    public ListView(Iterable<T> collection, Predicate<T> filter) {
        this.collection = collection;
        this.filter = filter;
    }

    public void iterate(Consumer<T> consumer) {
        for (T t : this.collection) {
            if (this.filter.test(t)) continue;
            consumer.accept(t);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new FilterIterator();
    }

    private class FilterIterator
    implements Iterator<T> {
        private final Iterator<T> iterator;
        private T next;

        private FilterIterator() {
            this.iterator = ListView.this.collection.iterator();
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            if (this.iterator.hasNext()) {
                this.next = this.iterator.next();
                if (ListView.this.filter.test(this.next)) {
                    return this.hasNext();
                }
                return true;
            }
            return false;
        }

        @Override
        public T next() {
            return this.next;
        }
    }
}

