/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.util;

import com.mojang.serialization.Lifecycle;
import com.terraforged.engine.concurrent.Resource;
import com.terraforged.engine.concurrent.ThreadLocalResource;
import com.terraforged.mod.LevelType;
import com.terraforged.mod.Log;
import com.terraforged.mod.chunk.settings.TerraSettings;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.world.Dimension;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.EndBiomeProvider;
import net.minecraft.world.biome.provider.NetherBiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraftforge.common.world.ForgeWorldType;
import net.minecraftforge.registries.ForgeRegistries;

public class DimUtils {
    private static final ThreadLocalResource<Map<ForgeWorldType, SimpleRegistry<Dimension>>> CACHE = ThreadLocalResource.withInitial(HashMap::new, Map::clear);

    public static RegistryKey<DimensionType> getOverworldType() {
        return DimensionType.field_235999_c_;
    }

    public static SimpleRegistry<Dimension> createDimensionRegistry(long seed, DynamicRegistries registries, ChunkGenerator generator) {
        SimpleRegistry registry = new SimpleRegistry(Registry.field_239700_af_, Lifecycle.stable());
        registry.func_218381_a(Dimension.field_236053_b_, (Object)DimUtils.createDimension(DimUtils.getOverworldType(), registries, generator), Lifecycle.stable());
        registry.func_218381_a(Dimension.field_236054_c_, (Object)DimUtils.createDefaultNether(seed, registries), Lifecycle.stable());
        registry.func_218381_a(Dimension.field_236055_d_, (Object)DimUtils.createDefaultEnd(seed, registries), Lifecycle.stable());
        return registry;
    }

    public static SimpleRegistry<Dimension> updateDimensionRegistry(SimpleRegistry<Dimension> registry, DynamicRegistries registries, ChunkGenerator generator) {
        Dimension dimension = DimUtils.createDimension(DimUtils.getOverworldType(), registries, generator);
        registry.func_241874_a(OptionalInt.empty(), Dimension.field_236053_b_, (Object)dimension, Lifecycle.stable());
        return registry;
    }

    public static DimensionGeneratorSettings populateDimensions(DimensionGeneratorSettings level, DynamicRegistries registries, TerraSettings settings) {
        try (Resource ignored = (Resource)CACHE.get();){
            DimUtils.overrideDimension((RegistryKey<Dimension>)Dimension.field_236054_c_, settings.dimensions.dimensions.nether, level, registries);
            DimUtils.overrideDimension((RegistryKey<Dimension>)Dimension.field_236055_d_, settings.dimensions.dimensions.end, level, registries);
            if (settings.dimensions.dimensions.includeExtraDimensions) {
                DimUtils.addExtraDimensions(level, registries);
            }
        }
        return level;
    }

    private static void overrideDimension(RegistryKey<Dimension> key, String levelType, DimensionGeneratorSettings level, DynamicRegistries registries) {
        SimpleRegistry<Dimension> dimensions = DimUtils.getDimensions(levelType, level, registries);
        if (dimensions == null) {
            return;
        }
        Dimension dimension = (Dimension)dimensions.func_230516_a_(key);
        if (dimension == null) {
            return;
        }
        Log.info("Overriding dimension {} with {}'s", key.func_240901_a_(), levelType);
        level.func_236224_e_().func_241874_a(OptionalInt.empty(), key, (Object)dimension, Lifecycle.stable());
    }

    private static void addExtraDimensions(DimensionGeneratorSettings level, DynamicRegistries registries) {
        for (ForgeWorldType type : ForgeRegistries.WORLD_TYPES) {
            SimpleRegistry<Dimension> dimensions;
            if (type == LevelType.TERRAFORGED || (dimensions = DimUtils.getDimensions(type, level, registries)) == null) continue;
            for (Map.Entry entry : dimensions.func_239659_c_()) {
                if (level.func_236224_e_().func_230516_a_((RegistryKey)entry.getKey()) != null) continue;
                Log.info("Adding extra dimension {} dimension from {}", ((RegistryKey)entry.getKey()).func_240901_a_(), type.getRegistryName());
                level.func_236224_e_().func_218381_a((RegistryKey)entry.getKey(), entry.getValue(), Lifecycle.stable());
            }
        }
    }

    @Nullable
    private static SimpleRegistry<Dimension> getDimensions(String levelType, DimensionGeneratorSettings level, DynamicRegistries registries) {
        ForgeWorldType type = DimUtils.getLevelType(levelType);
        return DimUtils.getDimensions(type, level, registries);
    }

    @Nullable
    private static SimpleRegistry<Dimension> getDimensions(ForgeWorldType type, DimensionGeneratorSettings level, DynamicRegistries registries) {
        if (type == null || type == LevelType.TERRAFORGED) {
            return null;
        }
        return CACHE.open().computeIfAbsent(type, t -> {
            long seed = level.func_236221_b_();
            boolean chest = level.func_236223_d_();
            boolean structures = level.func_236222_c_();
            return t.createSettings(registries, seed, structures, chest, "").func_236224_e_();
        });
    }

    private static Dimension createDefaultNether(long seed, DynamicRegistries registries) {
        return DimUtils.createDefaultDimension(seed, (RegistryKey<DimensionType>)DimensionType.field_236000_d_, (RegistryKey<DimensionSettings>)DimensionSettings.field_242736_e, registries, (arg_0, arg_1) -> ((NetherBiomeProvider.Preset)NetherBiomeProvider.Preset.field_235288_b_).func_242619_a(arg_0, arg_1));
    }

    private static Dimension createDefaultEnd(long seed, DynamicRegistries registries) {
        return DimUtils.createDefaultDimension(seed, (RegistryKey<DimensionType>)DimensionType.field_236001_e_, (RegistryKey<DimensionSettings>)DimensionSettings.field_242737_f, registries, EndBiomeProvider::new);
    }

    private static Dimension createDefaultDimension(long seed, RegistryKey<DimensionType> type, RegistryKey<DimensionSettings> setting, DynamicRegistries registries, BiFunction<Registry<Biome>, Long, BiomeProvider> factory) {
        MutableRegistry biomes = registries.func_243612_b(Registry.field_239720_u_);
        MutableRegistry settings = registries.func_243612_b(Registry.field_243549_ar);
        Supplier<DimensionSettings> settingSupplier = () -> DimUtils.lambda$createDefaultDimension$1((Registry)settings, setting);
        BiomeProvider biomeProvider = factory.apply((Registry<Biome>)biomes, seed);
        NoiseChunkGenerator generator = new NoiseChunkGenerator(biomeProvider, seed, settingSupplier);
        return DimUtils.createDimension(type, registries, (ChunkGenerator)generator);
    }

    private static Dimension createDimension(RegistryKey<DimensionType> type, DynamicRegistries registries, ChunkGenerator generator) {
        Log.info("Creating dimension: {}", type.func_240901_a_());
        MutableRegistry types = registries.func_243612_b(Registry.field_239698_ad_);
        Supplier<DimensionType> typeSupplier = () -> DimUtils.lambda$createDimension$2((Registry)types, type);
        return new Dimension(typeSupplier, generator);
    }

    public static String getDisplayString(ForgeWorldType type) {
        if (type == LevelType.TERRAFORGED) {
            return "default";
        }
        return String.valueOf(type.getRegistryName());
    }

    public static ForgeWorldType getLevelType(String name) {
        if (name.equalsIgnoreCase("default")) {
            return LevelType.TERRAFORGED;
        }
        ResourceLocation location = ResourceLocation.func_208304_a((String)name);
        if (location == null || location.equals((Object)LevelType.TERRAFORGED.getRegistryName())) {
            return LevelType.TERRAFORGED;
        }
        ForgeWorldType type = (ForgeWorldType)ForgeRegistries.WORLD_TYPES.getValue(location);
        if (type == null) {
            return LevelType.TERRAFORGED;
        }
        return type;
    }

    private static /* synthetic */ DimensionType lambda$createDimension$2(Registry types, RegistryKey type) {
        return (DimensionType)types.func_243576_d(type);
    }

    private static /* synthetic */ DimensionSettings lambda$createDefaultDimension$1(Registry settings, RegistryKey setting) {
        return (DimensionSettings)settings.func_243576_d(setting);
    }
}

