/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.structure;

import com.terraforged.mod.Log;
import com.terraforged.mod.chunk.TFChunkGenerator;
import com.terraforged.mod.config.ConfigManager;
import com.terraforged.mod.structure.StructureSearch;
import com.terraforged.mod.util.quadsearch.QuadSearch;
import com.terraforged.mod.util.quadsearch.SearchContext;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;

public class StructureLocator {
    public static final String ASYNC_KEY = "async_structure_search";
    public static final String TIMEOUT_KEY = "structure_search_timeout";
    public static final boolean DEFAULT_ASYNC = true;
    public static final long DEFAULT_TIMEOUT_MS = 5000L;
    private static final int ASYNC_SPACING_THRESHOLD = 26;
    private static final String UNSAFE_ERROR = "Async search for structure {} failed! It might not be thread-safe! \nError: {}";
    private static final String FALLBACK_MESSAGE = "Falling back to synchronous search for structure {}";
    private static final Set<Structure<?>> unsafeStructures = Collections.newSetFromMap(new ConcurrentHashMap());

    public static BlockPos find(BlockPos center, int radius, boolean skipExisting, Structure<?> structure, StructureSeparationSettings settings, IWorld world, TFChunkGenerator generator) {
        long timeout = ConfigManager.GENERAL.getLong(TIMEOUT_KEY, 5000L);
        if (world instanceof ServerWorld) {
            boolean async = ConfigManager.GENERAL.getBool(ASYNC_KEY, true);
            return StructureLocator.search(center, radius, structure, settings, async, timeout, new StructureSearch(center, skipExisting, structure, settings, (ServerWorld)world, generator));
        }
        return StructureLocator.search(center, radius, structure, settings, false, timeout, new StructureSearch(center, skipExisting, structure, settings, world, generator));
    }

    private static BlockPos search(BlockPos center, int radius, Structure<?> structure, StructureSeparationSettings settings, boolean async, long timeoutMS, StructureSearch search) {
        int chunkX = center.func_177958_n() >> 4;
        int chunkZ = center.func_177952_p() >> 4;
        int spacing = settings.func_236668_a_();
        SearchContext context = new SearchContext(timeoutMS, TimeUnit.MILLISECONDS);
        if (async && spacing <= 26 && !unsafeStructures.contains(structure)) {
            BlockPos result = QuadSearch.asyncSearch(chunkX, chunkZ, radius, spacing, search, context);
            if (result != null) {
                return result;
            }
            Throwable error = search.error();
            if (error == null) {
                return null;
            }
            unsafeStructures.add(structure);
            Log.err(UNSAFE_ERROR, structure.getRegistryName(), StructureLocator.getError(error));
            if (context.hasTimedOut()) {
                return null;
            }
            search = search.reset();
            context = context.newWithTimeout();
            Log.debug(FALLBACK_MESSAGE, structure.getRegistryName());
        }
        return QuadSearch.search(chunkX, chunkZ, radius, spacing, search, context);
    }

    /*
     * Exception decompiling
     */
    private static String getError(Throwable throwable) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

