/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.server.command.search.condition;

import com.terraforged.engine.cell.Cell;
import com.terraforged.engine.util.pos.PosUtil;
import com.terraforged.engine.world.heightmap.Heightmap;
import com.terraforged.engine.world.terrain.Terrain;
import com.terraforged.engine.world.terrain.TerrainType;
import com.terraforged.mod.server.command.search.Search;
import com.terraforged.mod.server.command.search.condition.SearchCondition;
import net.minecraft.util.math.BlockPos;

public class VolcanoMatch
implements SearchCondition {
    private final Heightmap heightmap;
    private final LocalSearch search;

    public VolcanoMatch(Terrain terrain, Heightmap heightmap) {
        this.heightmap = heightmap;
        this.search = new LocalSearch(new BlockPos.Mutable(), heightmap);
    }

    @Override
    public long test(Cell cell, int x, int z) {
        int centerX = PosUtil.unpackLeft(cell.terrainRegionCenter);
        int centerY = PosUtil.unpackRight(cell.terrainRegionCenter);
        this.heightmap.apply(cell, centerX, centerY);
        if (cell.terrain == TerrainType.VOLCANO_PIPE) {
            return cell.terrainRegionCenter;
        }
        if (cell.terrain == TerrainType.VOLCANO) {
            this.search.center.func_181079_c(centerX, 0, centerY);
            BlockPos result = this.search.get();
            if (result != BlockPos.field_177992_a) {
                return PosUtil.pack(result.func_177958_n(), result.func_177952_p());
            }
        }
        return Long.MAX_VALUE;
    }

    private static class LocalSearch
    extends Search {
        private final Heightmap heightmap;
        private final BlockPos.Mutable center;
        private final Cell cell = new Cell();

        public LocalSearch(BlockPos.Mutable center, Heightmap heightmap) {
            super((BlockPos)center, 0, 400);
            this.center = center;
            this.heightmap = heightmap;
        }

        @Override
        public int getSpacing() {
            return 2;
        }

        @Override
        public boolean test(BlockPos pos) {
            this.heightmap.apply(this.cell, pos.func_177958_n(), pos.func_177952_p());
            return this.cell.terrain == TerrainType.VOLCANO_PIPE;
        }
    }
}

