/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.material.geology;

import com.terraforged.engine.world.geology.Strata;
import com.terraforged.mod.api.material.geology.StrataConfig;
import com.terraforged.mod.api.material.geology.StrataGenerator;
import com.terraforged.mod.material.Materials;
import com.terraforged.noise.Source;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;

public class GeoGenerator
implements StrataGenerator {
    private final List<Block> rock;
    private final List<Block> soil;
    private final List<Block> clay;
    private final List<Block> sediment;
    private final List<Source> types = new ArrayList<Source>();

    public GeoGenerator(Materials materials) {
        this.types.add(Source.PERLIN);
        this.rock = Materials.toList(materials.stone);
        this.soil = Materials.toList(materials.dirt);
        this.clay = Materials.toList(materials.clay);
        this.sediment = Materials.toList(materials.sediment);
    }

    @Override
    public Strata<BlockState> generate(int seed, int scale, StrataConfig config) {
        Random random = new Random();
        Strata.Builder<BlockState> builder = Strata.builder(++seed, Source.build(++seed, scale, 3));
        this.addLayer(seed + 1, random, config.soil, this.soil, builder);
        this.addLayer(seed + 2, random, config.sediment, this.sediment, builder);
        this.addLayer(seed + 3, random, config.clay, this.clay, builder);
        this.addLayer(seed + 4, random, config.rock, this.rock, builder);
        return builder.build();
    }

    private void addLayer(int seed, Random random, StrataConfig.Config config, List<Block> materials, Strata.Builder<BlockState> builder) {
        if (materials.size() == 0) {
            return;
        }
        random.setSeed(seed);
        List<Layer> layers = this.generateLayers(materials, config, random);
        layers.forEach(l -> builder.add(((Layer)l).type, ((Layer)l).state, ((Layer)l).depth));
    }

    private List<Layer> generateLayers(List<Block> materials, StrataConfig.Config config, Random random) {
        int lastIndex = -1;
        int layers = config.getLayers(random.nextFloat());
        ArrayList<Layer> result = new ArrayList<Layer>();
        for (int i = 0; i < layers; ++i) {
            int attempts = 3;
            int index = random.nextInt(materials.size());
            while (--attempts >= 0 && index == lastIndex) {
                index = random.nextInt(materials.size());
            }
            if (index == lastIndex) continue;
            lastIndex = index;
            BlockState material = materials.get(index).func_176223_P();
            float depth = config.getDepth(random.nextFloat());
            Source type = this.nextType(random);
            result.add(new Layer(material, depth, type));
        }
        return result;
    }

    private Source nextType(Random random) {
        int index = random.nextInt(this.types.size());
        return this.types.get(index);
    }

    private List<Layer> sortHardness(List<Layer> layers) {
        layers.sort(Comparator.comparing(s -> Float.valueOf(Materials.getHardness(((Layer)s).state))));
        return layers;
    }

    private static class Layer {
        private final BlockState state;
        private final float depth;
        private final Source type;

        private Layer(BlockState state, float depth, Source type) {
            this.state = state;
            this.depth = depth;
            this.type = type;
        }
    }
}

