/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.util.codec;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.OptionalDynamic;
import com.terraforged.mod.featuremanager.FeatureManager;
import com.terraforged.mod.featuremanager.util.codec.CodecException;
import com.terraforged.mod.featuremanager.util.codec.DecoderFunc;
import com.terraforged.mod.featuremanager.util.codec.EncoderFunc;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class Codecs {
    public static final Marker MARKER = MarkerManager.getMarker((String)"Codecs");

    public static <V> Codec<V> create(EncoderFunc<V> encoder, DecoderFunc<V> decoder) {
        return Codec.of(encoder, decoder).stable();
    }

    public static <V> Codec<V> create(EncoderFunc.Simple<V> encoder, DecoderFunc.Simple<V> decoder) {
        return Codec.of(encoder, decoder).stable();
    }

    public static <V, T> V decodeAndGet(Codec<V> codec, OptionalDynamic<T> dynamic) {
        return (V)dynamic.result().flatMap(d -> Codecs.decode(codec, d)).orElseThrow(CodecException.decode(dynamic));
    }

    public static <V, T> V decodeAndGet(Codec<V> codec, Dynamic<T> dynamic) {
        return Codecs.decode(codec, dynamic).orElseThrow(CodecException.decode(dynamic));
    }

    public static <V, T> V decodeAndGet(Codec<V> codec, T value, DynamicOps<T> ops) {
        return Codecs.decode(codec, value, ops).orElseThrow(CodecException.decode(value));
    }

    public static <V, T> Optional<V> decode(Codec<V> codec, OptionalDynamic<T> dynamic) {
        return dynamic.result().flatMap(d -> Codecs.decode(codec, d));
    }

    public static <V, T> Optional<V> decode(Codec<V> codec, Dynamic<T> dynamic) {
        return Codecs.decode(codec, dynamic.getValue(), dynamic.getOps());
    }

    public static <V, T> Optional<V> decode(Codec<V> codec, T input, DynamicOps<T> ops) {
        return Codecs.getResult(codec.decode(ops, input)).map(Pair::getFirst);
    }

    public static <V> Optional<V> decode(Codec<V> codec, JsonElement element) {
        return Codecs.decode(codec, element, JsonOps.INSTANCE);
    }

    public static <V, T> DataResult<T> encode(Codec<V> codec, V value, DynamicOps<T> ops) {
        return codec.encodeStart(ops, value);
    }

    public static <V, T> T encodeAndGet(Codec<V> codec, V value, DynamicOps<T> ops) {
        return Codecs.getOrThrow(codec.encodeStart(ops, value));
    }

    public static <V> JsonElement encode(Codec<V> codec, V value) {
        return (JsonElement)Codecs.getResult(Codecs.encode(codec, value, JsonOps.INSTANCE)).orElse(JsonNull.INSTANCE);
    }

    public static <V> Optional<JsonElement> encodeOpt(Codec<V> codec, V value) {
        return Codecs.getResult(Codecs.encode(codec, value, JsonOps.INSTANCE));
    }

    public static <V, T> T createList(Codec<V> codec, DynamicOps<T> ops, List<V> list) {
        return (T)Codecs.getResult(codec.listOf().encodeStart(ops, list)).orElseGet(() -> ops.createList(Stream.empty()));
    }

    public static <T> T getOrThrow(DataResult<T> result) {
        String error = null;
        if (result.error().isPresent()) {
            error = ((DataResult.PartialResult)result.error().get()).message();
        }
        return result.result().orElseThrow(CodecException.get(error, new Object[0]));
    }

    public static <T> T modify(T value, Codec<T> codec, UnaryOperator<JsonElement> modifier) {
        try {
            JsonElement input = (JsonElement)Codecs.getResult(Codecs.encode(codec, value, JsonOps.INSTANCE)).orElseThrow(() -> CodecException.of("Failed to encode: %s", value));
            JsonElement output = (JsonElement)modifier.apply(input);
            return Codecs.decodeAndGet(codec, output, JsonOps.INSTANCE);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return value;
        }
    }

    public static <V, T> Optional<V> getField(T value, Codec<T> codec, Function<JsonElement, V> mapper, String path) {
        return Codecs.getField(value, codec, mapper, new String[]{path});
    }

    public static <V, T> Optional<V> getField(T value, Codec<T> codec, Function<JsonElement, V> mapper, String ... path) {
        JsonElement element = Codecs.encode(codec, value);
        for (String key : path) {
            if (!element.isJsonObject()) {
                return Optional.empty();
            }
            element = element.getAsJsonObject().get(key);
        }
        return Optional.ofNullable(mapper.apply(element));
    }

    public static <T> Optional<T> getResult(DataResult<T> result) {
        return result.resultOrPartial(message -> FeatureManager.LOG.log(Level.ERROR, MARKER, message));
    }
}

